/// <reference path="./internal_*.d.ts" />
declare namespace net.minecraft.util {
    class Unit extends Internal.Enum<net.minecraft.util.Unit> {
        static values(): net.minecraft.util.Unit[];
        static valueOf($$0: string): net.minecraft.util.Unit;
        static readonly INSTANCE: net.minecraft.util.Unit;
    }
    type Unit_ = "instance" | Unit;
}
declare namespace Internal {
    class CookingUpgradeConfig {
        constructor(builder: Internal.ForgeConfigSpec$Builder_, upgradeName: string, path: string)
        static getInstance(builder: Internal.ForgeConfigSpec$Builder_, upgradeName: string, path: string): Internal.CookingUpgradeConfig;
        readonly cookingSpeedMultiplier: Internal.ForgeConfigSpec$DoubleValue;
        readonly fuelEfficiencyMultiplier: Internal.ForgeConfigSpec$DoubleValue;
    }
    type CookingUpgradeConfig_ = CookingUpgradeConfig;
    interface Long2FloatFunction extends it.unimi.dsi.fastutil.Function<number, number>, Internal.LongToDoubleFunction {
        remove(arg0: number): number;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, number>;
        composeByte(arg0: Internal.Byte2LongFunction_): Internal.Byte2FloatFunction;
        apply(arg0: number): number;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        andThenShort(arg0: Internal.Float2ShortFunction_): Internal.Long2ShortFunction;
        defaultReturnValue(arg0: number): void;
        composeChar(arg0: Internal.Char2LongFunction_): Internal.Char2FloatFunction;
        andThenByte(arg0: Internal.Float2ByteFunction_): Internal.Long2ByteFunction;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        composeShort(arg0: Internal.Short2LongFunction_): Internal.Short2FloatFunction;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<number, T>;
        andThenChar(arg0: Internal.Float2CharFunction_): Internal.Long2CharFunction;
        andThenInt(arg0: Internal.Float2IntFunction_): Internal.Long2IntFunction;
        defaultReturnValue(): number;
        composeFloat(arg0: Internal.Float2LongFunction_): Internal.Float2FloatFunction;
        abstract get(arg0: number): number;
        containsKey(arg0: number): boolean;
        composeReference<T>(arg0: Internal.Reference2LongFunction_<T>): Internal.Reference2FloatFunction<T>;
        andThenDouble(arg0: Internal.Float2DoubleFunction_): Internal.Long2DoubleFunction;
        put(arg0: number, arg1: number): number;
        composeLong(arg0: Internal.Long2LongFunction_): this;
        andThenObject<T>(arg0: Internal.Float2ObjectFunction_<T>): Internal.Long2ObjectFunction<T>;
        applyAsDouble(arg0: number): number;
        andThenReference<T>(arg0: Internal.Float2ReferenceFunction_<T>): Internal.Long2ReferenceFunction<T>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: number): number;
        composeObject<T>(arg0: Internal.Object2LongFunction_<T>): Internal.Object2FloatFunction<T>;
        size(): number;
        composeDouble(arg0: Internal.Double2LongFunction_): Internal.Double2FloatFunction;
        andThenLong(arg0: Internal.Float2LongFunction_): Internal.Long2LongFunction;
        clear(): void;
        andThenFloat(arg0: Internal.Float2FloatFunction_): this;
        composeInt(arg0: Internal.Int2LongFunction_): Internal.Int2FloatFunction;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        identity<T>(): Internal.Function<T, T>;
        getOrDefault(arg0: number, arg1: number): number;
        (arg0: number): number;
    }
    type Long2FloatFunction_ = Long2FloatFunction;
    interface MapDecorationExtensions {
        render(index: number): boolean;
    }
    type MapDecorationExtensions_ = MapDecorationExtensions;
    class AlwaysTrueTest extends Internal.RuleTest {
        static readonly CODEC: Internal.Codec<Internal.AlwaysTrueTest>;
        static readonly INSTANCE: Internal.AlwaysTrueTest;
    }
    type AlwaysTrueTest_ = AlwaysTrueTest;
    interface Ingredient$Value {
        abstract serialize(): Internal.JsonObject;
        abstract getItems(): Internal.Collection<Internal.ItemStack>;
        get items(): Internal.Collection<Internal.ItemStack>
    }
    type Ingredient$Value_ = Ingredient$Value;
    class SlabBlockBuilder extends Internal.ShapedBlockBuilder {
        constructor(i: ResourceLocation_)
        /**
         * Tags both the block and the item with the given tag.
        */
        tag(arg0: ResourceLocation_): Internal.BuilderBase<any>;
        createObject(): Internal.Block;
    }
    type SlabBlockBuilder_ = SlabBlockBuilder;
    class MultiplierNBT$Serializer implements Internal.JsonDeserializer<Internal.MultiplierNBT>, Internal.JsonSerializer<Internal.MultiplierNBT> {
        deserialize(arg0: Internal.JsonElement_, arg1: Internal.Type_, arg2: Internal.JsonDeserializationContext_): any;
        serialize(stats: Internal.MultiplierNBT_, typeOfSrc: Internal.Type_, context: Internal.JsonSerializationContext_): Internal.JsonElement;
        serialize(arg0: any, arg1: Internal.Type_, arg2: Internal.JsonSerializationContext_): Internal.JsonElement;
    }
    type MultiplierNBT$Serializer_ = MultiplierNBT$Serializer;
    interface TaggedChoiceTypeExtension {
        abstract fabric$setFailSoft(arg0: boolean): void;
        (arg0: boolean): void;
    }
    type TaggedChoiceTypeExtension_ = TaggedChoiceTypeExtension;
    class TwistingVinesConfig extends Internal.Record implements Internal.FeatureConfiguration {
        constructor($$0: number, $$1: number, $$2: number)
        spreadWidth(): number;
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        spreadHeight(): number;
        maxHeight(): number;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        static readonly CODEC: Internal.Codec<Internal.TwistingVinesConfig>;
    }
    type TwistingVinesConfig_ = TwistingVinesConfig;
    interface SpectatorMenuCategory {
        abstract getPrompt(): net.minecraft.network.chat.Component;
        abstract getItems(): Internal.List<Internal.SpectatorMenuItem>;
        get prompt(): net.minecraft.network.chat.Component
        get items(): Internal.List<Internal.SpectatorMenuItem>
    }
    type SpectatorMenuCategory_ = SpectatorMenuCategory;
    class SculkSpreader {
        constructor($$0: boolean, $$1: Internal.TagKey_<Internal.Block>, $$2: number, $$3: number, $$4: number, $$5: number)
        static createWorldGenSpreader(): Internal.SculkSpreader;
        growthSpawnCost(): number;
        replaceableBlocks(): Internal.TagKey<Internal.Block>;
        chargeDecayRate(): number;
        additionalDecayRate(): number;
        updateCursors($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.RandomSource_, $$3: boolean): void;
        getCursors(): Internal.List<Internal.SculkSpreader$ChargeCursor>;
        save($$0: Internal.CompoundTag_): void;
        addCursors($$0: BlockPos_, $$1: number): void;
        load($$0: Internal.CompoundTag_): void;
        isWorldGeneration(): boolean;
        clear(): void;
        noGrowthRadius(): number;
        static createLevelSpreader(): Internal.SculkSpreader;
        get cursors(): Internal.List<Internal.SculkSpreader$ChargeCursor>
        get worldGeneration(): boolean
        static readonly MAX_GROWTH_RATE_RADIUS: 24;
        static readonly MAX_DECAY_FACTOR: 0.5;
        static readonly SHRIEKER_PLACEMENT_RATE: 11;
        static readonly MAX_CHARGE: 1000;
    }
    type SculkSpreader_ = SculkSpreader;
    class DisplayCastingRecipe implements Internal.IDisplayableCastingRecipe {
        constructor(type: Internal.RecipeType_<any>, castItems: Internal.List_<Internal.ItemStack>, fluids: Internal.List_<Internal.FluidStack>, output: Internal.ItemStack_, coolingTime: number, consumed: boolean)
        getOutput(): Internal.ItemStack;
        getType(): Internal.RecipeType<any>;
        getCoolingTime(): number;
        hasCast(): boolean;
        isConsumed(): boolean;
        getFluids(): Internal.List<Internal.FluidStack>;
        getCastItems(): Internal.List<Internal.ItemStack>;
        get output(): Internal.ItemStack
        get type(): Internal.RecipeType<any>
        get coolingTime(): number
        get consumed(): boolean
        get fluids(): Internal.List<Internal.FluidStack>
        get castItems(): Internal.List<Internal.ItemStack>
    }
    type DisplayCastingRecipe_ = DisplayCastingRecipe;
    interface Remapper {
        getMappedClass(from: typeof any): string;
        getUnmappedClass(from: string): string;
        getMappedField(from: typeof any, field: Internal.Field_): string;
        getTypeName(type: string): string;
        getMappedMethod(from: typeof any, method: Internal.Method_): string;
    }
    type Remapper_ = Remapper;
    class Climate$Sampler extends Internal.Record implements Internal.MultiNoiseSamplerHooks {
        constructor($$0: Internal.DensityFunction_, $$1: Internal.DensityFunction_, $$2: Internal.DensityFunction_, $$3: Internal.DensityFunction_, $$4: Internal.DensityFunction_, $$5: Internal.DensityFunction_, $$6: Internal.List_<Internal.Climate$ParameterPoint>)
        fabric_getSeed(): number;
        fabric_getEndBiomesSampler(): Internal.ImprovedNoise;
        spawnTarget(): Internal.List<Internal.Climate$ParameterPoint>;
        findSpawnPosition(): BlockPos;
        sample($$0: number, $$1: number, $$2: number): Internal.Climate$TargetPoint;
        fabric_setSeed(seed: number): void;
        temperature(): Internal.DensityFunction;
        humidity(): Internal.DensityFunction;
        weirdness(): Internal.DensityFunction;
        depth(): Internal.DensityFunction;
        continentalness(): Internal.DensityFunction;
        erosion(): Internal.DensityFunction;
    }
    type Climate$Sampler_ = Climate$Sampler;
    class CarriageContraptionEntity extends Internal.OrientedContraptionEntity implements Internal.AccessorCarriageContraptionEntity, Internal.IUpdateCount, Internal.IDistanceTravelled {
        constructor(type: Internal.EntityType_<any>, world: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        isLiving(): boolean;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        alwaysAccepts(): boolean;
        getCarriageData(): Internal.CarriageSyncData;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        railways$fromParent(parent: Internal.IUpdateCount_): void;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        isFrame(): boolean;
        syncCarriage(): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        playSound(id: Internal.SoundEvent_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        isLocalCoordWithin(localPos: BlockPos_, min: number, max: number): boolean;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        railways$getUpdateCount(): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        getCarriage(): Internal.Carriage;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        railways$getDistanceTravelled(): number;
        checkConductors(): Internal.Couple<boolean>;
        getType(): string;
        railways$setCarriage(arg0: Internal.Carriage_): void;
        self(): Internal.Entity;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        sophisticatedInvalidateCaps(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        sendCarriageDataUpdate(): void;
        spawn(): void;
        static create(world: Internal.Level_, contraption: Internal.CarriageContraption_): Internal.CarriageContraptionEntity;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        railways$markUpdate(): void;
        railways$bindCarriage(): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        static outOfSync(a: Internal.IUpdateCount_, b: Internal.IUpdateCount_): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setCarriage(carriage: Internal.Carriage_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        hasSchedule(): boolean;
        serializeNBT(): Internal.Tag;
        setDynamicLightEnabled(enabled: boolean): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        setServerSidePrevPosition(): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        onCarriageDataUpdate(newData: Internal.CarriageSyncData_): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        updateRenderedPortalCutoff(): void;
        lithiumOnBlockCacheDeleted(): void;
        runCommand(command: string): number;
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get carriageData(): Internal.CarriageSyncData
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        get facing(): Internal.Direction
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get frame(): boolean
        set motionY(y: number)
        get peacefulCreature(): boolean
        get carriage(): Internal.Carriage
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set carriage(carriage: Internal.Carriage_)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set dynamicLightEnabled(enabled: boolean)
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        sounds: Internal.CarriageSounds;
        movingBackwards: boolean;
        leftTickingChunks: boolean;
        trainId: Internal.UUID;
        validForRender: boolean;
        carriageData: Internal.CarriageSyncData;
        carriageIndex: number;
        firstPositionUpdate: boolean;
        particles: Internal.CarriageParticles;
    }
    type CarriageContraptionEntity_ = CarriageContraptionEntity;
    class PackRepository implements Internal.IPackRepository, Internal.PackRepositoryAccessor, Internal.PackRepositoryExtension, io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor.PackRepositoryAccessor {
        constructor(...$$0: Internal.RepositorySource_[])
        isAvailable($$0: string): boolean;
        reload(): void;
        openAllSelected(): Internal.List<Internal.PackResources>;
        getSelectedPacks(): Internal.Collection<Internal.Pack>;
        "handler$cla000$fabric-resource-loader-v0$construct"(resourcePackProviders: Internal.RepositorySource_[], info: Internal.CallbackInfo_): void;
        setSources(arg0: Internal.Set_<any>): void;
        voicechat$addSource(source: Internal.RepositorySource_): void;
        getAvailableIds(): Internal.Collection<string>;
        setSelected($$0: Internal.Collection_<string>): void;
        removePack($$0: string): boolean;
        getSources(): Internal.Set<any>;
        getSelectedIds(): Internal.Collection<string>;
        handler$zcp000$porting_lib_base$addModdedPacks(repositorySources: Internal.RepositorySource_[], ci: Internal.CallbackInfo_): void;
        pl$addPackFinder(packFinder: Internal.RepositorySource_): void;
        getPack($$0: string): Internal.Pack;
        addPack($$0: string): boolean;
        getRequestedFeatureFlags(): Internal.FeatureFlagSet;
        getAvailablePacks(): Internal.Collection<Internal.Pack>;
        get selectedPacks(): Internal.Collection<Internal.Pack>
        set sources(arg0: Internal.Set_<any>)
        get availableIds(): Internal.Collection<string>
        set selected($$0: Internal.Collection_<string>)
        get sources(): Internal.Set<any>
        get selectedIds(): Internal.Collection<string>
        get requestedFeatureFlags(): Internal.FeatureFlagSet
        get availablePacks(): Internal.Collection<Internal.Pack>
        sources: Internal.Set<Internal.RepositorySource>;
    }
    type PackRepository_ = PackRepository;
    class SnowGolem extends Internal.AbstractGolem implements Internal.Shearable, Internal.RangedAttackMob, Internal.IShearable {
        constructor($$0: Internal.EntityType_<Internal.SnowGolem>, $$1: Internal.Level_)
        isShearable(item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_): boolean;
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        readyForShearing(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        hasPumpkin(): boolean;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        onSheared(player: Internal.Player_, item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_, fortune: number): Internal.List<any>;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        shear($$0: Internal.SoundSource_): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        performRangedAttack($$0: Internal.LivingEntity_, $$1: number): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        setPumpkin($$0: boolean): void;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        set pumpkin($$0: boolean)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type SnowGolem_ = SnowGolem;
    class DensityFunctions$TwoArgumentSimpleFunction$Type extends Internal.Enum<Internal.DensityFunctions$TwoArgumentSimpleFunction$Type> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static valueOf($$0: string): Internal.DensityFunctions$TwoArgumentSimpleFunction$Type;
        static values(): Internal.DensityFunctions$TwoArgumentSimpleFunction$Type[];
        get serializedName(): string
        static readonly MUL: Internal.DensityFunctions$TwoArgumentSimpleFunction$Type;
        static readonly MAX: Internal.DensityFunctions$TwoArgumentSimpleFunction$Type;
        static readonly ADD: Internal.DensityFunctions$TwoArgumentSimpleFunction$Type;
        static readonly MIN: Internal.DensityFunctions$TwoArgumentSimpleFunction$Type;
    }
    type DensityFunctions$TwoArgumentSimpleFunction$Type_ = "min" | "mul" | "max" | DensityFunctions$TwoArgumentSimpleFunction$Type | "add";
    class DeltaFeature extends Internal.Feature<Internal.DeltaFeatureConfiguration> {
        constructor($$0: Internal.Codec_<Internal.DeltaFeatureConfiguration>)
    }
    type DeltaFeature_ = DeltaFeature;
    interface Float2ReferenceFunction <V> extends Internal.DoubleFunction<V>, it.unimi.dsi.fastutil.Function<number, V> {
        composeByte(arg0: Internal.Byte2FloatFunction_): Internal.Byte2ReferenceFunction<V>;
        andThenReference<T>(arg0: Internal.Reference2ReferenceFunction_<V, T>): Internal.Float2ReferenceFunction<T>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: V): V;
        composeObject<T>(arg0: Internal.Object2FloatFunction_<T>): Internal.Object2ReferenceFunction<T, V>;
        andThen<V>(arg0: Internal.Function_<V, V>): Internal.Function<number, V>;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: V): V;
        getOrDefault(arg0: number, arg1: V): V;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        composeShort(arg0: Internal.Short2FloatFunction_): Internal.Short2ReferenceFunction<V>;
        composeFloat(arg0: Internal.Float2FloatFunction_): this;
        /**
         * @deprecated
        */
        get(arg0: any): V;
        remove(arg0: number): V;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        composeInt(arg0: Internal.Int2FloatFunction_): Internal.Int2ReferenceFunction<V>;
        /**
         * @deprecated
        */
        remove(arg0: any): V;
        andThenFloat(arg0: Internal.Reference2FloatFunction_<V>): Internal.Float2FloatFunction;
        abstract get(arg0: number): V;
        containsKey(arg0: number): boolean;
        andThenLong(arg0: Internal.Reference2LongFunction_<V>): Internal.Float2LongFunction;
        /**
         * @deprecated
        */
        apply(arg0: number): V;
        andThenInt(arg0: Internal.Reference2IntFunction_<V>): Internal.Float2IntFunction;
        andThenByte(arg0: Internal.Reference2ByteFunction_<V>): Internal.Float2ByteFunction;
        apply(arg0: number): V;
        composeChar(arg0: Internal.Char2FloatFunction_): Internal.Char2ReferenceFunction<V>;
        andThenShort(arg0: Internal.Reference2ShortFunction_<V>): Internal.Float2ShortFunction;
        composeDouble(arg0: Internal.Double2FloatFunction_): Internal.Double2ReferenceFunction<V>;
        composeLong(arg0: Internal.Long2FloatFunction_): Internal.Long2ReferenceFunction<V>;
        size(): number;
        andThenObject<T>(arg0: Internal.Reference2ObjectFunction_<V, T>): Internal.Float2ObjectFunction<T>;
        clear(): void;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, V>;
        defaultReturnValue(): V;
        andThenDouble(arg0: Internal.Reference2DoubleFunction_<V>): Internal.Float2DoubleFunction;
        andThenChar(arg0: Internal.Reference2CharFunction_<V>): Internal.Float2CharFunction;
        put(arg0: number, arg1: V): V;
        composeReference<T>(arg0: Internal.Reference2FloatFunction_<T>): Internal.Reference2ReferenceFunction<T, V>;
        identity<T>(): Internal.Function<T, T>;
        defaultReturnValue(arg0: V): void;
        (arg0: number): V;
    }
    type Float2ReferenceFunction_<V> = Float2ReferenceFunction<V>;
    class ClientboundSetTimePacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: number, $$1: number, $$2: boolean)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getGameTime(): number;
        getDayTime(): number;
        isSkippable(): boolean;
        get gameTime(): number
        get dayTime(): number
        get skippable(): boolean
    }
    type ClientboundSetTimePacket_ = ClientboundSetTimePacket;
    class DetectorBlock$Builder extends Internal.BlockBuilder {
        constructor(i: ResourceLocation_)
        /**
         * Tags both the block and the item with the given tag.
        */
        tag(arg0: ResourceLocation_): Internal.BuilderBase<any>;
        detectorId(id: string): this;
        createObject(): Internal.Block;
    }
    type DetectorBlock$Builder_ = DetectorBlock$Builder;
    class EncasedCogwheelBlock extends Internal.RotatedPillarKineticBlock implements Internal.IBE<Internal.SimpleKineticBlockEntity>, Internal.BlockPickInteractionAware, Internal.ICogWheel, Internal.EncasedBlock, Internal.SpecialBlockItemRequirement, Internal.TransformableBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_, large: boolean, casing: Internal.Supplier_<Internal.Block>)
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.SimpleKineticBlockEntity>): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        isSmallCog(): boolean;
        swapShafts(state: Internal.BlockState_): Internal.BlockState;
        getRequiredItems(state: Internal.BlockState_, be: Internal.BlockEntity_): Internal.ItemRequirement;
        getBlockEntityClass(): typeof Internal.SimpleKineticBlockEntity;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        transform(state: Internal.BlockState_, transform: Internal.StructureTransform_): Internal.BlockState;
        isLargeCog(): boolean;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        setLightEmission(v: number): void;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.SimpleKineticBlockEntity>;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getPickedStack(state: Internal.BlockState_, view: Internal.BlockGetter_, pos: BlockPos_, player: Internal.Player_, target: Internal.HitResult_): Internal.ItemStack;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        static isSmallCogItem(test: Internal.ItemStack_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.SimpleKineticBlockEntity;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        static isLargeCog(state: Internal.BlockState_): boolean;
        isDedicatedCogWheel(): boolean;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        getCasing(): Internal.Block;
        static isLargeCogItem(test: Internal.ItemStack_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        hideStressImpact(): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        static isSmallCog(state: Internal.BlockState_): boolean;
        getBlockEntityType(): Internal.BlockEntityType<Internal.SimpleKineticBlockEntity>;
        setRequiresTool(v: boolean): void;
        static isLargeCog(block: Internal.Block_): boolean;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.SimpleKineticBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        static isDedicatedCogWheel(block: Internal.Block_): boolean;
        static isSmallCog(block: Internal.Block_): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        swapShaftsForRotation(state: Internal.BlockState_, rotation: Internal.Rotation_, rotationAxis: Internal.Direction$Axis_): Internal.BlockState;
        showCapacityWithAnnotation(): boolean;
        static isDedicatedCogItem(test: Internal.ItemStack_): boolean;
        emi(amount: number): Internal.EmiStack;
        handleEncasing(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, heldItem: Internal.ItemStack_, player: Internal.Player_, hand: Internal.InteractionHand_, ray: Internal.BlockHitResult_): void;
        get smallCog(): boolean
        get blockEntityClass(): typeof Internal.SimpleKineticBlockEntity
        get largeCog(): boolean
        set lightEmission(v: number)
        set destroySpeed(v: number)
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
        get dedicatedCogWheel(): boolean
        get casing(): Internal.Block
        get blockStates(): Internal.List<Internal.BlockState>
        get blockEntityType(): Internal.BlockEntityType<Internal.SimpleKineticBlockEntity>
        set requiresTool(v: boolean)
        get mod(): string
        static readonly BOTTOM_SHAFT: Internal.BooleanProperty;
        static readonly TOP_SHAFT: Internal.BooleanProperty;
    }
    type EncasedCogwheelBlock_ = EncasedCogwheelBlock;
    class MoltenSteelFluid$Source extends Internal.MoltenSteelFluid {
        constructor(properties: Internal.ModFlowingFluid$Properties_, block: Internal.Supplier_<Internal.LiquidBlock>)
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type MoltenSteelFluid$Source_ = MoltenSteelFluid$Source;
    interface SpriteContentsFrameInfoAccessor {
        abstract getTime(): number;
        abstract getIndex(): number;
        get time(): number
        get index(): number
    }
    type SpriteContentsFrameInfoAccessor_ = SpriteContentsFrameInfoAccessor;
    abstract class SimpleDirectionalFluid extends Internal.StarFluid {
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type SimpleDirectionalFluid_ = SimpleDirectionalFluid;
    class NameMap <E> implements Internal.Iterable<E> {
        get(index: number): E;
        getDisplayName(value: E): net.minecraft.network.chat.Component;
        getIndex(e: E): number;
        getNullable(s: string): E;
        forEach(arg0: Internal.Consumer_<E>): void;
        write(data: Internal.FriendlyByteBuf_, object: E): void;
        read(data: Internal.FriendlyByteBuf_): E;
        offset(value: E, index: number): E;
        iterator(): Internal.Iterator<E>;
        size(): number;
        static of<T>(defaultValue: T, values: Internal.List_<T>): Internal.NameMap$Builder<T>;
        static of<T>(defaultValue: T, values: T[]): Internal.NameMap$Builder<T>;
        get(s: string): E;
        getIcon(v: E): Internal.Icon;
        getName(value: E): string;
        getColor(value: E): Internal.Color4I;
        spliterator(): Internal.Spliterator<E>;
        withDefault(def: E): this;
        getPrevious(value: E): E;
        getNext(value: E): E;
        getRandom(rand: Internal.Random_): E;
        getStringIndex(s: string): number;
        readonly keys: Internal.List<string>;
        readonly values: Internal.List<E>;
        readonly map: Internal.Map<string, E>;
        readonly defaultValue: E;
    }
    type NameMap_<E> = NameMap<E>;
    class Date implements Internal.Cloneable, Internal.Comparable<Internal.Date>, Internal.Serializable {
        constructor()
        constructor(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number)
        constructor(arg0: number, arg1: number, arg2: number)
        constructor(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number)
        constructor(arg0: number)
        constructor(arg0: string)
        clone(): any;
        /**
         * @deprecated
        */
        getHours(): number;
        toInstant(): Internal.Instant;
        compareTo(arg0: any): number;
        /**
         * @deprecated
        */
        setDate(arg0: number): void;
        /**
         * @deprecated
        */
        getMonth(): number;
        /**
         * @deprecated
        */
        static parse(arg0: string): number;
        /**
         * @deprecated
        */
        getTimezoneOffset(): number;
        before(arg0: Internal.Date_): boolean;
        /**
         * @deprecated
        */
        setMonth(arg0: number): void;
        compareTo(arg0: Internal.Date_): number;
        /**
         * @deprecated
        */
        getSeconds(): number;
        /**
         * @deprecated
        */
        getMinutes(): number;
        /**
         * @deprecated
        */
        setYear(arg0: number): void;
        getTime(): number;
        /**
         * @deprecated
        */
        setHours(arg0: number): void;
        /**
         * @deprecated
        */
        setMinutes(arg0: number): void;
        /**
         * @deprecated
        */
        setSeconds(arg0: number): void;
        static from(arg0: Internal.Instant_): Internal.Date;
        /**
         * @deprecated
        */
        getYear(): number;
        /**
         * @deprecated
        */
        toGMTString(): string;
        after(arg0: Internal.Date_): boolean;
        /**
         * @deprecated
        */
        toLocaleString(): string;
        /**
         * @deprecated
        */
        getDate(): number;
        /**
         * @deprecated
        */
        getDay(): number;
        /**
         * @deprecated
        */
        static UTC(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): number;
        setTime(arg0: number): void;
        /**
         * @deprecated
        */
        get hours(): number
        /**
         * @deprecated
        */
        set date(arg0: number)
        /**
         * @deprecated
        */
        get month(): number
        /**
         * @deprecated
        */
        get timezoneOffset(): number
        /**
         * @deprecated
        */
        set month(arg0: number)
        /**
         * @deprecated
        */
        get seconds(): number
        /**
         * @deprecated
        */
        get minutes(): number
        /**
         * @deprecated
        */
        set year(arg0: number)
        get time(): number
        /**
         * @deprecated
        */
        set hours(arg0: number)
        /**
         * @deprecated
        */
        set minutes(arg0: number)
        /**
         * @deprecated
        */
        set seconds(arg0: number)
        /**
         * @deprecated
        */
        get year(): number
        /**
         * @deprecated
        */
        get date(): number
        /**
         * @deprecated
        */
        get day(): number
        set time(arg0: number)
    }
    type Date_ = Date;
    class Random implements Internal.RandomGenerator, Internal.Serializable {
        constructor()
        constructor(arg0: number)
        ints(arg0: number, arg1: number): Internal.IntStream;
        nextFloat(arg0: number): number;
        static getDefault(): Internal.RandomGenerator;
        nextLong(): number;
        nextDouble(): number;
        nextLong(arg0: number, arg1: number): number;
        nextGaussian(): number;
        doubles(arg0: number, arg1: number, arg2: number): Internal.DoubleStream;
        nextDouble(arg0: number): number;
        nextInt(arg0: number): number;
        nextFloat(): number;
        nextLong(arg0: number): number;
        ints(arg0: number, arg1: number, arg2: number): Internal.IntStream;
        nextFloat(arg0: number, arg1: number): number;
        static of(arg0: string): Internal.RandomGenerator;
        doubles(): Internal.DoubleStream;
        nextInt(): number;
        nextBytes(arg0: number[]): void;
        longs(arg0: number): Internal.LongStream;
        longs(arg0: number, arg1: number, arg2: number): Internal.LongStream;
        nextBoolean(): boolean;
        nextDouble(arg0: number, arg1: number): number;
        setSeed(arg0: number): void;
        nextExponential(): number;
        longs(arg0: number, arg1: number): Internal.LongStream;
        nextInt(arg0: number, arg1: number): number;
        longs(): Internal.LongStream;
        isDeprecated(): boolean;
        doubles(arg0: number): Internal.DoubleStream;
        nextGaussian(arg0: number, arg1: number): number;
        ints(): Internal.IntStream;
        ints(arg0: number): Internal.IntStream;
        static from(arg0: Internal.RandomGenerator_): Internal.Random;
        doubles(arg0: number, arg1: number): Internal.DoubleStream;
        get "default"(): Internal.RandomGenerator
        set seed(arg0: number)
        get deprecated(): boolean
    }
    type Random_ = Random;
    class EtrionicCapacitorItem extends Internal.Item implements Internal.BotariumEnergyItem<Internal.WrappedItemEnergyContainer> {
        constructor(properties: Internal.Item$Properties_)
        getEnergyStorage(arg0: Internal.ItemStack_): Internal.EnergyContainer;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        static mode(stack: Internal.ItemStack_): Internal.DistributionMode;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        static toggleMode(stack: Internal.ItemStack_): Internal.DistributionMode;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        static toggleActive(stack: Internal.ItemStack_): boolean;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        distributeSequential(from: Internal.ItemStackHolder_, maxExtract: number, inventory: Internal.Inventory_): void;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        distributeRoundRobin(from: Internal.ItemStackHolder_, maxExtract: number, inventory: Internal.Inventory_): void;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        static active(stack: Internal.ItemStack_): boolean;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly ACTIVE_TAG: "Active";
        static readonly MODE_TAG: "Mode";
    }
    type EtrionicCapacitorItem_ = EtrionicCapacitorItem;
    interface IOverflowResponseUpgrade {
        abstract worksInGui(): boolean;
        abstract onOverflow(arg0: Internal.ItemStack_): Internal.ItemStack;
        abstract stackMatchesFilter(arg0: Internal.ItemStack_): boolean;
        stackMatchesFilterStack(stack: Internal.ItemStack_, filterStack: Internal.ItemStack_): boolean;
        abstract getFilterLogic(): Internal.FilterLogic;
        get filterLogic(): Internal.FilterLogic
    }
    type IOverflowResponseUpgrade_ = IOverflowResponseUpgrade;
    interface PlayerEvents$PlayerBreakSpeed {
        abstract setBreakSpeed(arg0: Internal.PlayerEvents$BreakSpeed_): void;
        set breakSpeed(arg0: Internal.PlayerEvents$BreakSpeed_)
        (arg0: Internal.PlayerEvents$BreakSpeed): void;
    }
    type PlayerEvents$PlayerBreakSpeed_ = PlayerEvents$PlayerBreakSpeed;
    class SoundEventBuilder extends Internal.BuilderBase<Internal.SoundEvent> {
        constructor(i: ResourceLocation_)
        createObject(): any;
    }
    type SoundEventBuilder_ = SoundEventBuilder;
    interface ClimbingMobCachingSection {
        abstract collectPushableEntities(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.AABB_, arg3: Internal.EntityPushablePredicate_<Internal.Entity>, arg4: Internal.ArrayList_<Internal.Entity>): Internal.AbortableIterationConsumer$Continuation;
        abstract onEntityModifiedCachedBlock(arg0: Internal.BlockCachingEntity_, arg1: Internal.BlockState_): void;
    }
    type ClimbingMobCachingSection_ = ClimbingMobCachingSection;
    interface ContainerData {
        abstract getCount(): number;
        abstract get(arg0: number): number;
        abstract set(arg0: number, arg1: number): void;
        get count(): number
    }
    type ContainerData_ = ContainerData;
    class ZipEntry implements Internal.Cloneable, Internal.ZipConstants {
        constructor(arg0: Internal.ZipEntry_)
        constructor(arg0: string)
        clone(): any;
        setCompressedSize(arg0: number): void;
        setComment(arg0: string): void;
        isDirectory(): boolean;
        getLastAccessTime(): Internal.FileTime;
        getCrc(): number;
        getMethod(): number;
        getName(): string;
        getSize(): number;
        getTimeLocal(): Internal.LocalDateTime;
        setCrc(arg0: number): void;
        setExtra(arg0: number[]): void;
        getCreationTime(): Internal.FileTime;
        setLastAccessTime(arg0: Internal.FileTime_): this;
        setTimeLocal(arg0: Internal.LocalDateTime_): void;
        getCompressedSize(): number;
        getComment(): string;
        getTime(): number;
        getLastModifiedTime(): Internal.FileTime;
        setLastModifiedTime(arg0: Internal.FileTime_): this;
        setCreationTime(arg0: Internal.FileTime_): this;
        getExtra(): number[];
        setSize(arg0: number): void;
        setMethod(arg0: number): void;
        setTime(arg0: number): void;
        set compressedSize(arg0: number)
        set comment(arg0: string)
        get directory(): boolean
        get lastAccessTime(): Internal.FileTime
        get crc(): number
        get method(): number
        get name(): string
        get size(): number
        get timeLocal(): Internal.LocalDateTime
        set crc(arg0: number)
        set extra(arg0: number[])
        get creationTime(): Internal.FileTime
        set lastAccessTime(arg0: Internal.FileTime_)
        set timeLocal(arg0: Internal.LocalDateTime_)
        get compressedSize(): number
        get comment(): string
        get time(): number
        get lastModifiedTime(): Internal.FileTime
        set lastModifiedTime(arg0: Internal.FileTime_)
        set creationTime(arg0: Internal.FileTime_)
        get extra(): number[]
        set size(arg0: number)
        set method(arg0: number)
        set time(arg0: number)
        static readonly STORED: 0;
        static readonly DEFLATED: 8;
    }
    type ZipEntry_ = ZipEntry;
    interface FileNotFoundAction {
        copyResource(resourcePath: string): this;
        copyData(file: Internal.File_): this;
        copyData(file: Internal.Path_): this;
        copyData(data: Internal.InputStream_): this;
        copyData(url: Internal.URL_): this;
        abstract run(arg0: Internal.Path_, arg1: dev.lambdaurora.lambdynlights.shadow.nightconfig.core.ConfigFormat_<any>): boolean;
        (arg0: Internal.Path, arg1: dev.lambdaurora.lambdynlights.shadow.nightconfig.core.ConfigFormat<any>): boolean;
        readonly CREATE_EMPTY: Internal.FileNotFoundAction;
        readonly THROW_ERROR: Internal.FileNotFoundAction;
        readonly READ_NOTHING: Internal.FileNotFoundAction;
    }
    type FileNotFoundAction_ = FileNotFoundAction;
    interface ISlotLimitUpgrade {
        abstract getSlotLimit(): number;
        get slotLimit(): number
        (): number;
    }
    type ISlotLimitUpgrade_ = ISlotLimitUpgrade;
    class Clipboard {
        constructor(arg0: string)
        removeFlavorListener(arg0: Internal.FlavorListener_): void;
        getContents(arg0: any): Internal.Transferable;
        getName(): string;
        getData(arg0: Internal.DataFlavor_): any;
        isDataFlavorAvailable(arg0: Internal.DataFlavor_): boolean;
        getAvailableDataFlavors(): Internal.DataFlavor[];
        addFlavorListener(arg0: Internal.FlavorListener_): void;
        setContents(arg0: Internal.Transferable_, arg1: Internal.ClipboardOwner_): void;
        getFlavorListeners(): Internal.FlavorListener[];
        get name(): string
        get availableDataFlavors(): Internal.DataFlavor[]
        get flavorListeners(): Internal.FlavorListener[]
    }
    type Clipboard_ = Clipboard;
    class BlockPathTypes extends Internal.Enum<Internal.BlockPathTypes> {
        static valueOf($$0: string): Internal.BlockPathTypes;
        static values(): Internal.BlockPathTypes[];
        getMalus(): number;
        get malus(): number
        static readonly STICKY_HONEY: Internal.BlockPathTypes;
        static readonly WALKABLE: Internal.BlockPathTypes;
        static readonly WATER_BORDER: Internal.BlockPathTypes;
        static readonly LAVA: Internal.BlockPathTypes;
        static readonly TRAPDOOR: Internal.BlockPathTypes;
        static readonly DAMAGE_CAUTIOUS: Internal.BlockPathTypes;
        static readonly FENCE: Internal.BlockPathTypes;
        static readonly OPEN: Internal.BlockPathTypes;
        static readonly UNPASSABLE_RAIL: Internal.BlockPathTypes;
        static readonly BLOCKED: Internal.BlockPathTypes;
        static readonly LEAVES: Internal.BlockPathTypes;
        static readonly DANGER_OTHER: Internal.BlockPathTypes;
        static readonly DANGER_POWDER_SNOW: Internal.BlockPathTypes;
        static readonly DOOR_WOOD_CLOSED: Internal.BlockPathTypes;
        static readonly DOOR_IRON_CLOSED: Internal.BlockPathTypes;
        static readonly BREACH: Internal.BlockPathTypes;
        static readonly COCOA: Internal.BlockPathTypes;
        static readonly DAMAGE_OTHER: Internal.BlockPathTypes;
        static readonly DAMAGE_FIRE: Internal.BlockPathTypes;
        static readonly WALKABLE_DOOR: Internal.BlockPathTypes;
        static readonly RAIL: Internal.BlockPathTypes;
        static readonly POWDER_SNOW: Internal.BlockPathTypes;
        static readonly DANGER_FIRE: Internal.BlockPathTypes;
        static readonly DOOR_OPEN: Internal.BlockPathTypes;
        static readonly WATER: Internal.BlockPathTypes;
    }
    type BlockPathTypes_ = "breach" | "lava" | "danger_powder_snow" | BlockPathTypes | "unpassable_rail" | "leaves" | "cocoa" | "rail" | "fence" | "trapdoor" | "danger_fire" | "blocked" | "walkable" | "open" | "door_iron_closed" | "walkable_door" | "powder_snow" | "damage_other" | "damage_cautious" | "door_wood_closed" | "door_open" | "danger_other" | "water" | "damage_fire" | "water_border" | "sticky_honey";
    class Property$Value <T extends Internal.Comparable<T>> extends Internal.Record {
        constructor($$0: Internal.Property_<T>, $$1: T)
        property(): Internal.Property<T>;
        value(): T;
    }
    type Property$Value_<T extends Internal.Comparable<T>> = Property$Value<T>;
    class CableBlock extends Internal.AbstractEnergyBlock<Internal.CableConfig, Internal.CableBlock> implements Internal.SimpleWaterloggedBlock, Internal.IEnergyConnector {
        constructor(properties: Internal.BlockBehaviour$Properties_, variant: owmii.powah.block.Tier_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        canAttach(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, direction: Internal.Direction_): boolean[];
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(level: Internal.Level_, state: Internal.BlockState_, blockEntityType: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        canConnectEnergy(world: Internal.Level_, pos: BlockPos_, direction: Internal.Direction_): boolean;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        getBlockItem(arg0: Internal.Item$Properties_, arg1: Internal.ResourceKey_<any>): Internal.ItemBlock<any, any>;
        getConfig(): Internal.CableConfig;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        static getHitSide(hit: Vec3d_, pos: BlockPos_): Internal.Optional<Internal.Direction>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        get config(): Internal.CableConfig
        set destroySpeed(v: number)
        static readonly NORTH: Internal.BooleanProperty;
        static readonly SOUTH: Internal.BooleanProperty;
        static readonly UP: Internal.BooleanProperty;
        static readonly WEST: Internal.BooleanProperty;
        static readonly DOWN: Internal.BooleanProperty;
        static readonly EAST: Internal.BooleanProperty;
    }
    type CableBlock_ = CableBlock;
    abstract class Reference <T> {
        refersTo(arg0: T): boolean;
        static reachabilityFence(arg0: any): void;
        /**
         * @deprecated
        */
        isEnqueued(): boolean;
        clear(): void;
        enqueue(): boolean;
        get(): T;
        /**
         * @deprecated
        */
        get enqueued(): boolean
    }
    type Reference_<T> = Reference<T>;
    interface ComposableEntryContainer {
        and($$0: Internal.ComposableEntryContainer_): this;
        or($$0: Internal.ComposableEntryContainer_): this;
        abstract expand(arg0: Internal.LootContext_, arg1: Internal.Consumer_<Internal.LootPoolEntry>): boolean;
        (arg0: Internal.LootContext, arg1: Internal.Consumer<Internal.LootPoolEntry>): boolean;
        readonly ALWAYS_TRUE: Internal.ComposableEntryContainer;
        readonly ALWAYS_FALSE: Internal.ComposableEntryContainer;
    }
    type ComposableEntryContainer_ = ComposableEntryContainer;
    class EditBox extends Internal.AbstractWidget implements Internal.EditBoxAccessor, Internal.GreedyInputComponent, Internal.Renderable, Internal.TextFieldWidgetAccessor, Internal.AccessEditBox {
        constructor($$0: net.minecraft.client.gui.Font_, $$1: number, $$2: number, $$3: number, $$4: number, $$5: net.minecraft.network.chat.Component_)
        constructor($$0: net.minecraft.client.gui.Font_, $$1: number, $$2: number, $$3: number, $$4: number, $$5: Internal.EditBox_, $$6: net.minecraft.network.chat.Component_)
        interpolate(arg0: Internal.Animatable_<any>, arg1: number): Internal.Animatable<any>;
        insertText($$0: string): void;
        setSuggestion($$0: string): void;
        intersects(other: Internal.PositionedRectangle_): boolean;
        keyReleased($$0: number, $$1: number, $$2: number): boolean;
        isBordered(): boolean;
        remove(): void;
        setHint($$0: net.minecraft.network.chat.Component_): void;
        hasParent(): boolean;
        setTextColor($$0: number): void;
        drawTooltip(context: Internal.OwoUIDrawContext_, mouseX: number, mouseY: number, partialTicks: number, delta: number): void;
        method_48579($$0: Internal.GuiGraphics_, $$1: number, $$2: number, $$3: number): void;
        mouseMoved($$0: number, $$1: number): void;
        isVisible(): boolean;
        deleteWords($$0: number): void;
        setResponder($$0: Internal.Consumer_<string>): void;
        getInnerWidth(): number;
        getValue(): string;
        setHighlightPos($$0: number): void;
        getMaxLength(): number;
        setPosition($$0: number, $$1: number): void;
        setCursorPosition($$0: number): void;
        method_47399($$0: Internal.NarrationElementOutput_): void;
        getHighlighted(): string;
        moveCursorToEnd(): void;
        sizing(horizontalSizing: Internal.Sizing_, verticalSizing: Internal.Sizing_): io.wispforest.owo.ui.core.Component;
        canConsumeInput(): boolean;
        tick(): void;
        owo$drawsBackground(): boolean;
        setCanLoseFocus($$0: boolean): void;
        setValue($$0: string): void;
        isEditable(): boolean;
        intersection(other: Internal.PositionedRectangle_): Internal.PositionedRectangle;
        moveCursorToStart(): void;
        interpolate(next: Internal.PositionedRectangle_, delta: number): Internal.PositionedRectangle;
        root(): Internal.ParentComponent;
        setEditable($$0: boolean): void;
        tooltip(tooltip: net.minecraft.network.chat.Component_): io.wispforest.owo.ui.core.Component;
        static of(x: number, y: number, width: number, height: number): Internal.PositionedRectangle;
        searchables$getResponder(): Internal.Consumer<any>;
        getScreenX($$0: number): number;
        moveCursor($$0: number): void;
        setTextColorUneditable($$0: number): void;
        setBordered($$0: boolean): void;
        searchables$getFilter(): Internal.Predicate<any>;
        getCursorPosition(): number;
        mouseScrolled($$0: number, $$1: number, $$2: number): boolean;
        setFormatter($$0: Internal.BiFunction_<string, number, Internal.FormattedCharSequence>): void;
        moveTo(x: number, y: number): void;
        setFilter($$0: Internal.Predicate_<string>): void;
        getIsEditable(): boolean;
        isInBoundingBox(x: number, y: number): boolean;
        fullSize(): Internal.Size;
        setMaxLength($$0: number): void;
        getResponder(): Internal.Consumer<any>;
        tooltip(tooltip: Internal.Collection_<net.minecraft.network.chat.Component>): io.wispforest.owo.ui.core.Component;
        getWordPosition($$0: number): number;
        moveCursorTo($$0: number): void;
        sizing(sizing: Internal.Sizing_): io.wispforest.owo.ui.core.Component;
        drawFocusHighlight(context: Internal.OwoUIDrawContext_, mouseX: number, mouseY: number, partialTicks: number, delta: number): void;
        static of(x: number, y: number, size: Internal.Size_): Internal.PositionedRectangle;
        getCurrentFocusPath(): Internal.ComponentPath;
        deleteChars($$0: number): void;
        setVisible($$0: boolean): void;
        set suggestion($$0: string)
        get bordered(): boolean
        set hint($$0: net.minecraft.network.chat.Component_)
        set textColor($$0: number)
        get visible(): boolean
        set responder($$0: Internal.Consumer_<string>)
        get innerWidth(): number
        get value(): string
        set highlightPos($$0: number)
        get maxLength(): number
        set cursorPosition($$0: number)
        get highlighted(): string
        set canLoseFocus($$0: boolean)
        set value($$0: string)
        get editable(): boolean
        set editable($$0: boolean)
        set textColorUneditable($$0: number)
        set bordered($$0: boolean)
        get cursorPosition(): number
        set formatter($$0: Internal.BiFunction_<string, number, Internal.FormattedCharSequence>)
        set filter($$0: Internal.Predicate_<string>)
        get isEditable(): boolean
        set maxLength($$0: number)
        get responder(): Internal.Consumer<any>
        get currentFocusPath(): Internal.ComponentPath
        set visible($$0: boolean)
        static readonly FORWARDS: 1;
        textColor: number;
        static readonly BACKWARDS: -1;
        static readonly DEFAULT_TEXT_COLOR: 14737632;
    }
    type EditBox_ = EditBox;
    interface LevelAccessor extends Internal.CommonLevelAccessor, Internal.LevelTimeAccess {
        getNearestPlayer($$0: Internal.TargetingConditions_, $$1: Internal.LivingEntity_): Internal.Player;
        dayTime(): number;
        abstract getShade(arg0: Internal.Direction_, arg1: boolean): number;
        getSignal($$0: BlockPos_, $$1: Internal.Direction_): number;
        isUnobstructed($$0: Internal.Entity_, $$1: Internal.VoxelShape_): boolean;
        getMaxSection(): number;
        abstract getLevelData(): Internal.LevelData;
        getBrightness($$0: Internal.LightLayer_, $$1: BlockPos_): number;
        getSectionYFromSectionIndex($$0: number): number;
        abstract players(): Internal.List<Internal.Player>;
        abstract getBiomeManager(): Internal.BiomeManager;
        abstract getRandom(): Internal.RandomSource;
        isEmptyBlock($$0: BlockPos_): boolean;
        getMaxLocalRawBrightness($$0: BlockPos_, $$1: number): number;
        abstract removeBlock(arg0: BlockPos_, arg1: boolean): boolean;
        playSound($$0: Internal.Player_, $$1: BlockPos_, $$2: Internal.SoundEvent_, $$3: Internal.SoundSource_): void;
        getBlockCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Iterable<Internal.VoxelShape>;
        isOutsideBuildHeight($$0: BlockPos_): boolean;
        getTimeOfDay($$0: number): number;
        /**
         * @deprecated
        */
        hasChunksAt($$0: number, $$1: number, $$2: number, $$3: number): boolean;
        getHeightmapPos($$0: Internal.Heightmap$Types_, $$1: BlockPos_): BlockPos;
        blockUpdated($$0: BlockPos_, $$1: Internal.Block_): void;
        abstract setBlock(arg0: BlockPos_, arg1: Internal.BlockState_, arg2: number, arg3: number): boolean;
        abstract isClientSide(): boolean;
        getEntities($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.List<Internal.Entity>;
        getEntitiesOfClass<T extends Internal.Entity>($$0: T, $$1: Internal.AABB_): Internal.List<T>;
        abstract getBlockTicks(): Internal.LevelTickAccess<Internal.Block>;
        getBlockStates($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        getPathfindingCostFromLightLevels($$0: BlockPos_): number;
        abstract dimensionType(): Internal.DimensionType;
        abstract getSkyDarken(): number;
        getMinBuildHeight(): number;
        scheduleTick($$0: BlockPos_, $$1: Internal.Fluid_, $$2: number): void;
        getLoadedChunk(chunkX: number, chunkZ: number): Internal.ChunkAccess;
        getBiomeFabric(pos: BlockPos_): Internal.Holder<any>;
        getNearestPlayer($$0: number, $$1: number, $$2: number, $$3: number, $$4: boolean): Internal.Player;
        abstract destroyBlock(arg0: BlockPos_, arg1: boolean, arg2: Internal.Entity_, arg3: number): boolean;
        /**
         * @deprecated
        */
        hasChunkAt($$0: number, $$1: number): boolean;
        /**
         * @deprecated
        */
        abstract getSeaLevel(): number;
        abstract getFluidTicks(): Internal.LevelTickAccess<Internal.Fluid>;
        getSectionIndex($$0: number): number;
        getDirectSignalTo($$0: BlockPos_): number;
        getNearestPlayer($$0: Internal.TargetingConditions_, $$1: number, $$2: number, $$3: number): Internal.Player;
        getMaxBuildHeight(): number;
        /**
         * @deprecated
        */
        hasChunksAt($$0: BlockPos_, $$1: BlockPos_): boolean;
        destroyBlock($$0: BlockPos_, $$1: boolean): boolean;
        scheduleTick($$0: BlockPos_, $$1: Internal.Block_, $$2: number): void;
        getChunk($$0: number, $$1: number): Internal.ChunkAccess;
        addFreshEntity($$0: Internal.Entity_): boolean;
        hasSignal($$0: BlockPos_, $$1: Internal.Direction_): boolean;
        getCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Iterable<Internal.VoxelShape>;
        destroyBlock($$0: BlockPos_, $$1: boolean, $$2: Internal.Entity_): boolean;
        getHeight(): number;
        getChunk($$0: BlockPos_): Internal.ChunkAccess;
        abstract isFluidAtPosition(arg0: BlockPos_, arg1: Internal.Predicate_<Internal.FluidState>): boolean;
        abstract getWorldBorder(): Internal.WorldBorder;
        getMaxLocalRawBrightness($$0: BlockPos_): number;
        isUnobstructed($$0: Internal.BlockState_, $$1: BlockPos_, $$2: Internal.CollisionContext_): boolean;
        /**
         * @deprecated
        */
        getBlockEntityRenderAttachment(pos: BlockPos_): any;
        /**
         * @deprecated
        */
        hasChunkAt($$0: BlockPos_): boolean;
        getBiome($$0: BlockPos_): Internal.Holder<Internal.Biome>;
        /**
         * @deprecated
        */
        getLightLevelDependentMagicValue($$0: BlockPos_): number;
        scheduleTick($$0: BlockPos_, $$1: Internal.Block_, $$2: number, $$3: Internal.TickPriority_): void;
        hasNearbyAlivePlayer($$0: number, $$1: number, $$2: number, $$3: number): boolean;
        abstract gameEvent(arg0: Internal.GameEvent_, arg1: Vec3d_, arg2: Internal.GameEvent$Context_): void;
        getEntitiesOfClass<T extends Internal.Entity>($$0: T, $$1: Internal.AABB_, $$2: Internal.Predicate_<T>): Internal.List<T>;
        getNearestPlayer($$0: Internal.TargetingConditions_, $$1: Internal.LivingEntity_, $$2: number, $$3: number, $$4: number): Internal.Player;
        neighborShapeChanged($$0: Internal.Direction_, $$1: Internal.BlockState_, $$2: BlockPos_, $$3: BlockPos_, $$4: number, $$5: number): void;
        getControlInputSignal($$0: BlockPos_, $$1: Internal.Direction_, $$2: boolean): number;
        getBlockTint($$0: BlockPos_, $$1: Internal.ColorResolver_): number;
        getMinSection(): number;
        findFreePosition($$0: Internal.Entity_, $$1: Internal.VoxelShape_, $$2: Vec3d_, $$3: number, $$4: number, $$5: number): Internal.Optional<Vec3d>;
        abstract getBlockState(arg0: BlockPos_): Internal.BlockState;
        clipWithInteractionOverride($$0: Vec3d_, $$1: Vec3d_, $$2: BlockPos_, $$3: Internal.VoxelShape_, $$4: Internal.BlockState_): Internal.BlockHitResult;
        abstract playSound(arg0: Internal.Player_, arg1: BlockPos_, arg2: Internal.SoundEvent_, arg3: Internal.SoundSource_, arg4: number, arg5: number): void;
        getNearestPlayer($$0: Internal.Entity_, $$1: number): Internal.Player;
        hasNeighborSignal($$0: BlockPos_): boolean;
        getLightEmission($$0: BlockPos_): number;
        getBlockFloorHeight($$0: BlockPos_): number;
        getBlockStatesIfLoaded($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        create($$0: number, $$1: number): Internal.LevelHeightAccessor;
        clip($$0: Internal.ClipContext_): Internal.BlockHitResult;
        /**
         * @deprecated
        */
        hasChunksAt($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number): boolean;
        getBlockEntity<T extends Internal.BlockEntity>($$0: BlockPos_, $$1: Internal.BlockEntityType_<T>): Internal.Optional<T>;
        getRawBrightness($$0: BlockPos_, $$1: number): number;
        abstract addParticle(arg0: Internal.ParticleOptions_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number): void;
        abstract getCurrentDifficultyAt(arg0: BlockPos_): Internal.DifficultyInstance;
        getDifficulty(): Internal.Difficulty;
        canSeeSky($$0: BlockPos_): boolean;
        abstract enabledFeatures(): Internal.FeatureFlagSet;
        getMoonPhase(): number;
        isUnobstructed($$0: Internal.Entity_): boolean;
        getNearestEntity<T extends Internal.LivingEntity>($$0: Internal.List_<T>, $$1: Internal.TargetingConditions_, $$2: Internal.LivingEntity_, $$3: number, $$4: number, $$5: number): T;
        abstract getUncachedNoiseBiome(arg0: number, arg1: number, arg2: number): Internal.Holder<Internal.Biome>;
        abstract getEntities(arg0: Internal.Entity_, arg1: Internal.AABB_, arg2: Internal.Predicate_<Internal.Entity>): Internal.List<Internal.Entity>;
        getPlayerByUUID($$0: Internal.UUID_): Internal.Player;
        canSeeSkyFromBelowWater($$0: BlockPos_): boolean;
        holderLookup<T>($$0: Internal.ResourceKey_<Internal.Registry<T>>): Internal.HolderLookup<T>;
        abstract getHeight(arg0: Internal.Heightmap$Types_, arg1: number, arg2: number): number;
        getSectionsCount(): number;
        abstract isStateAtPosition(arg0: BlockPos_, arg1: Internal.Predicate_<Internal.BlockState>): boolean;
        getNearbyPlayers($$0: Internal.TargetingConditions_, $$1: Internal.LivingEntity_, $$2: Internal.AABB_): Internal.List<Internal.Player>;
        getSectionIndexFromSectionY($$0: number): number;
        abstract getServer(): Internal.MinecraftServer;
        abstract levelEvent(arg0: Internal.Player_, arg1: number, arg2: BlockPos_, arg3: number): void;
        setBlock($$0: BlockPos_, $$1: Internal.BlockState_, $$2: number): boolean;
        getChunk($$0: number, $$1: number, $$2: Internal.ChunkStatus_): Internal.ChunkAccess;
        noCollision($$0: Internal.Entity_): boolean;
        abstract getEntities<T extends Internal.Entity>(arg0: Internal.EntityTypeTest_<Internal.Entity, T>, arg1: Internal.AABB_, arg2: Internal.Predicate_<T>): Internal.List<T>;
        getBestNeighborSignal($$0: BlockPos_): number;
        hasChunk($$0: number, $$1: number): boolean;
        getNearbyEntities<T extends Internal.LivingEntity>($$0: T, $$1: Internal.TargetingConditions_, $$2: Internal.LivingEntity_, $$3: Internal.AABB_): Internal.List<T>;
        getBlockEntityRenderData(pos: BlockPos_): any;
        getMoonBrightness(): number;
        noCollision($$0: Internal.AABB_): boolean;
        isWaterAt($$0: BlockPos_): boolean;
        getDirectSignal($$0: BlockPos_, $$1: Internal.Direction_): number;
        getEntityCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.List<Internal.VoxelShape>;
        abstract getLightEngine(): Internal.LevelLightEngine;
        getBlockFloorHeight($$0: Internal.VoxelShape_, $$1: Internal.Supplier_<Internal.VoxelShape>): number;
        collidesWithSuffocatingBlock($$0: Internal.Entity_, $$1: Internal.AABB_): boolean;
        abstract getBlockEntity(arg0: BlockPos_): Internal.BlockEntity;
        getNoiseBiome($$0: number, $$1: number, $$2: number): Internal.Holder<Internal.Biome>;
        gameEvent($$0: Internal.GameEvent_, $$1: BlockPos_, $$2: Internal.GameEvent$Context_): void;
        noCollision($$0: Internal.Entity_, $$1: Internal.AABB_): boolean;
        scheduleTick($$0: BlockPos_, $$1: Internal.Fluid_, $$2: number, $$3: Internal.TickPriority_): void;
        isOutsideBuildHeight($$0: number): boolean;
        getNearestPlayer($$0: number, $$1: number, $$2: number, $$3: number, $$4: Internal.Predicate_<Internal.Entity>): Internal.Player;
        isBlockInLine($$0: Internal.ClipBlockStateContext_): Internal.BlockHitResult;
        gameEvent($$0: Internal.Entity_, $$1: Internal.GameEvent_, $$2: Vec3d_): void;
        abstract getFluidState(arg0: BlockPos_): Internal.FluidState;
        abstract getChunkSource(): Internal.ChunkSource;
        abstract getChunk(arg0: number, arg1: number, arg2: Internal.ChunkStatus_, arg3: boolean): Internal.ChunkAccess;
        abstract registryAccess(): Internal.RegistryAccess;
        findSupportingBlock($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Optional<BlockPos>;
        levelEvent($$0: number, $$1: BlockPos_, $$2: number): void;
        abstract nextSubTickCount(): number;
        gameEvent($$0: Internal.Entity_, $$1: Internal.GameEvent_, $$2: BlockPos_): void;
        getChunkForCollisions($$0: number, $$1: number): Internal.BlockGetter;
        containsAnyLiquid($$0: Internal.AABB_): boolean;
        hasBiomes(): boolean;
        getMaxLightLevel(): number;
        getNearestEntity<T extends Internal.LivingEntity>($$0: T, $$1: Internal.TargetingConditions_, $$2: Internal.LivingEntity_, $$3: number, $$4: number, $$5: number, $$6: Internal.AABB_): T;
        isAreaLoaded(center: BlockPos_, range: number): boolean;
        traverseBlocks<T, C>($$0: Vec3d_, $$1: Vec3d_, $$2: C, $$3: Internal.BiFunction_<C, BlockPos, T>, $$4: Internal.Function_<C, T>): T;
        get maxSection(): number
        get levelData(): Internal.LevelData
        get biomeManager(): Internal.BiomeManager
        get random(): Internal.RandomSource
        get clientSide(): boolean
        get blockTicks(): Internal.LevelTickAccess<Internal.Block>
        get skyDarken(): number
        get minBuildHeight(): number
        /**
         * @deprecated
        */
        get seaLevel(): number
        get fluidTicks(): Internal.LevelTickAccess<Internal.Fluid>
        get maxBuildHeight(): number
        get height(): number
        get worldBorder(): Internal.WorldBorder
        get minSection(): number
        get difficulty(): Internal.Difficulty
        get moonPhase(): number
        get sectionsCount(): number
        get server(): Internal.MinecraftServer
        get moonBrightness(): number
        get lightEngine(): Internal.LevelLightEngine
        get chunkSource(): Internal.ChunkSource
        get maxLightLevel(): number
    }
    type LevelAccessor_ = LevelAccessor;
    interface Char2DoubleFunction extends Internal.IntToDoubleFunction, it.unimi.dsi.fastutil.Function<string, number> {
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, string>): Internal.Function<T, number>;
        /**
         * @deprecated
        */
        applyAsDouble(arg0: number): number;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        remove(arg0: string): number;
        andThenShort(arg0: Internal.Double2ShortFunction_): Internal.Char2ShortFunction;
        composeObject<T>(arg0: Internal.Object2CharFunction_<T>): Internal.Object2DoubleFunction<T>;
        put(arg0: string, arg1: number): number;
        /**
         * @deprecated
        */
        put(arg0: string, arg1: number): number;
        composeReference<T>(arg0: Internal.Reference2CharFunction_<T>): Internal.Reference2DoubleFunction<T>;
        andThenByte(arg0: Internal.Double2ByteFunction_): Internal.Char2ByteFunction;
        composeLong(arg0: Internal.Long2CharFunction_): Internal.Long2DoubleFunction;
        containsKey(arg0: string): boolean;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        andThenLong(arg0: Internal.Double2LongFunction_): Internal.Char2LongFunction;
        andThenInt(arg0: Internal.Double2IntFunction_): Internal.Char2IntFunction;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        defaultReturnValue(arg0: number): void;
        andThenReference<T>(arg0: Internal.Double2ReferenceFunction_<T>): Internal.Char2ReferenceFunction<T>;
        apply(arg0: string): number;
        getOrDefault(arg0: string, arg1: number): number;
        andThenDouble(arg0: Internal.Double2DoubleFunction_): this;
        composeFloat(arg0: Internal.Float2CharFunction_): Internal.Float2DoubleFunction;
        composeDouble(arg0: Internal.Double2CharFunction_): Internal.Double2DoubleFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        abstract get(arg0: string): number;
        composeByte(arg0: Internal.Byte2CharFunction_): Internal.Byte2DoubleFunction;
        composeInt(arg0: Internal.Int2CharFunction_): Internal.Int2DoubleFunction;
        defaultReturnValue(): number;
        composeShort(arg0: Internal.Short2CharFunction_): Internal.Short2DoubleFunction;
        size(): number;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<string, T>;
        clear(): void;
        andThenFloat(arg0: Internal.Double2FloatFunction_): Internal.Char2FloatFunction;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        andThenChar(arg0: Internal.Double2CharFunction_): Internal.Char2CharFunction;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        andThenObject<T>(arg0: Internal.Double2ObjectFunction_<T>): Internal.Char2ObjectFunction<T>;
        identity<T>(): Internal.Function<T, T>;
        composeChar(arg0: Internal.Char2CharFunction_): this;
        (arg0: string): number;
    }
    type Char2DoubleFunction_ = Char2DoubleFunction;
    class GameRules$BooleanValue extends Internal.GameRules$Value<Internal.GameRules$BooleanValue> implements Internal.BooleanValueInvoker, Internal.GameRulesBooleanRuleAccessor {
        constructor($$0: Internal.GameRules$Type_<Internal.GameRules$BooleanValue>, $$1: boolean)
        setFrom($$0: Internal.GameRules$BooleanValue_, $$1: Internal.MinecraftServer_): void;
        static invokeCreate(defaultValue: boolean, onChanged: Internal.BiConsumer_<Internal.MinecraftServer, Internal.GameRules$BooleanValue>): Internal.GameRules$Type<Internal.GameRules$BooleanValue>;
        static invokeCreate$artifacts_$md$fca01f$0(arg0: boolean, arg1: Internal.BiConsumer_<any, any>): Internal.GameRules$Type<any>;
        set($$0: boolean, $$1: Internal.MinecraftServer_): void;
        static create($$0: boolean): Internal.GameRules$Type<Internal.GameRules$BooleanValue>;
        get(): boolean;
        static create($$0: boolean, $$1: Internal.BiConsumer_<Internal.MinecraftServer, Internal.GameRules$BooleanValue>): Internal.GameRules$Type<Internal.GameRules$BooleanValue>;
        static "invokeCreate$fabric-game-rule-api-v1_$md$fca01f$1"(arg0: boolean, arg1: Internal.BiConsumer_<any, any>): Internal.GameRules$Type<any>;
    }
    type GameRules$BooleanValue_ = GameRules$BooleanValue;
    class MoldBlock extends Internal.Block {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static canAttach(reader: Internal.LevelReader_, pos: BlockPos_, direction: Internal.Direction_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type MoldBlock_ = MoldBlock;
    interface CommandSource {
        abstract shouldInformAdmins(): boolean;
        abstract acceptsFailure(): boolean;
        alwaysAccepts(): boolean;
        abstract sendSystemMessage(arg0: net.minecraft.network.chat.Component_): void;
        abstract acceptsSuccess(): boolean;
        readonly NULL: Internal.CommandSource;
    }
    type CommandSource_ = CommandSource;
    abstract class EntityEventJS extends Internal.LevelEventJS {
        constructor()
        abstract getEntity(): Internal.Entity;
        getPlayer(): Internal.Player;
        get entity(): Internal.Entity
        get player(): Internal.Player
    }
    type EntityEventJS_ = EntityEventJS;
    class FireDragonCaveStructure extends Internal.DragonCaveStructure {
        static readonly CODEC: Internal.Codec<Internal.FireDragonCaveStructure>;
    }
    type FireDragonCaveStructure_ = FireDragonCaveStructure;
    class RootSystemFeature extends Internal.Feature<Internal.RootSystemConfiguration> {
        constructor($$0: Internal.Codec_<Internal.RootSystemConfiguration>)
    }
    type RootSystemFeature_ = RootSystemFeature;
    interface Cancellable {
        abstract isCancellable(): boolean;
        abstract cancel(): void;
        abstract isCancelled(): boolean;
        get cancellable(): boolean
        get cancelled(): boolean
    }
    type Cancellable_ = Cancellable;
    interface Config$Entry extends dev.lambdaurora.lambdynlights.shadow.nightconfig.core.UnmodifiableConfig$Entry {
        getChar(): string;
        getShortOrElse(defaultValue: number): number;
        abstract setValue<T>(arg0: any): T;
        getByte(): number;
        abstract getKey(): string;
        abstract getRawValue<T>(): T;
        getIntOrElse(defaultValue: number): number;
        getLongOrElse(defaultValue: number): number;
        getOptionalLong(): Internal.OptionalLong;
        getLong(): number;
        getByteOrElse(defaultValue: number): number;
        getShort(): number;
        getValue<T>(): T;
        isNull(): boolean;
        getOrElse<T>(defaultValue: T): T;
        getOptionalInt(): Internal.OptionalInt;
        getOptional<T>(): Internal.Optional<T>;
        getInt(): number;
        getCharOrElse(defaultValue: string): string;
        get "char"(): string
        set value(arg0: any)
        get "byte"(): number
        get key(): string
        get rawValue(): T
        get optionalLong(): Internal.OptionalLong
        get "long"(): number
        get "short"(): number
        get value(): T
        get "null"(): boolean
        get optionalInt(): Internal.OptionalInt
        get optional(): Internal.Optional<T>
        get "int"(): number
    }
    type Config$Entry_ = Config$Entry;
    class STBTTFontinfo$Buffer extends Internal.StructBuffer<Internal.STBTTFontinfo, Internal.STBTTFontinfo$Buffer> implements Internal.NativeResource {
        constructor(arg0: number, arg1: number)
        constructor(arg0: Internal.ByteBuffer_)
        close(): void;
    }
    type STBTTFontinfo$Buffer_ = STBTTFontinfo$Buffer;
    class TrueBlockPredicate implements net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate {
        static hasSturdyFace($$0: Internal.Direction_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static noFluid($$0: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        and(arg0: Internal.BiPredicate_<Internal.WorldGenLevel, BlockPos>): Internal.BiPredicate<Internal.WorldGenLevel, BlockPos>;
        static matchesTag($$0: Vec3i_, $$1: Internal.TagKey_<Internal.Block>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static anyOf($$0: Internal.List_<net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static noFluid(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static anyOf($$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_, $$1: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        negate(): Internal.BiPredicate<Internal.WorldGenLevel, BlockPos>;
        test($$0: Internal.WorldGenLevel_, $$1: BlockPos_): boolean;
        static solid($$0: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static insideWorld($$0: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        or(arg0: Internal.BiPredicate_<Internal.WorldGenLevel, BlockPos>): Internal.BiPredicate<Internal.WorldGenLevel, BlockPos>;
        static matchesTag($$0: Internal.TagKey_<Internal.Block>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static solid(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static alwaysTrue(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesBlocks($$0: Vec3i_, ...$$1: Internal.Block_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        type(): Internal.BlockPredicateType<any>;
        static matchesBlocks($$0: Vec3i_, $$1: Internal.List_<Internal.Block>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static allOf(...$$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static replaceable(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static wouldSurvive($$0: Internal.BlockState_, $$1: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesFluids($$0: Vec3i_, $$1: Internal.List_<Internal.Fluid>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static not($$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesFluids($$0: Vec3i_, ...$$1: Internal.Fluid_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static allOf($$0: Internal.List_<net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static allOf($$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_, $$1: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static anyOf(...$$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static replaceable($$0: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static hasSturdyFace($$0: Vec3i_, $$1: Internal.Direction_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        test(arg0: any, arg1: any): boolean;
        static matchesBlocks(...$$0: Internal.Block_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesBlocks($$0: Internal.List_<Internal.Block>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesFluids(...$$0: Internal.Fluid_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static INSTANCE: Internal.TrueBlockPredicate;
        static readonly CODEC: Internal.Codec<Internal.TrueBlockPredicate>;
    }
    type TrueBlockPredicate_ = TrueBlockPredicate;
    class ModuleDescriptor implements Internal.Comparable<Internal.ModuleDescriptor> {
        modifiers(): Internal.Set<Internal.ModuleDescriptor$Modifier>;
        uses(): Internal.Set<string>;
        static read(arg0: Internal.ByteBuffer_): Internal.ModuleDescriptor;
        static read(arg0: Internal.InputStream_, arg1: Internal.Supplier_<Internal.Set<string>>): Internal.ModuleDescriptor;
        exports(): Internal.Set<Internal.ModuleDescriptor$Exports>;
        compareTo(arg0: any): number;
        toNameAndVersion(): string;
        static newModule(arg0: string, arg1: Internal.Set_<Internal.ModuleDescriptor$Modifier>): Internal.ModuleDescriptor$Builder;
        isOpen(): boolean;
        static read(arg0: Internal.InputStream_): Internal.ModuleDescriptor;
        rawVersion(): Internal.Optional<string>;
        static read(arg0: Internal.ByteBuffer_, arg1: Internal.Supplier_<Internal.Set<string>>): Internal.ModuleDescriptor;
        accessFlags(): Internal.Set<Internal.AccessFlag>;
        isAutomatic(): boolean;
        static newOpenModule(arg0: string): Internal.ModuleDescriptor$Builder;
        requires(): Internal.Set<Internal.ModuleDescriptor$Requires>;
        name(): string;
        provides(): Internal.Set<Internal.ModuleDescriptor$Provides>;
        opens(): Internal.Set<Internal.ModuleDescriptor$Opens>;
        compareTo(arg0: Internal.ModuleDescriptor_): number;
        version(): Internal.Optional<Internal.ModuleDescriptor$Version>;
        mainClass(): Internal.Optional<string>;
        static newAutomaticModule(arg0: string): Internal.ModuleDescriptor$Builder;
        packages(): Internal.Set<string>;
        static newModule(arg0: string): Internal.ModuleDescriptor$Builder;
        get open(): boolean
        get automatic(): boolean
    }
    type ModuleDescriptor_ = ModuleDescriptor;
    interface AttributeSet$FontAttribute {
    }
    type AttributeSet$FontAttribute_ = AttributeSet$FontAttribute;
    abstract class AbstractIntCollection extends Internal.AbstractCollection<number> implements Internal.IntCollection {
        /**
         * @deprecated
        */
        stream(): Internal.Stream<number>;
        /**
         * @deprecated
        */
        add(arg0: number): boolean;
        contains(arg0: number): boolean;
        toIntArray(): number[];
        forEach(arg0: Internal.IntConsumer_): void;
        intStream(): Internal.IntStream;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        toArray(arg0: number[]): number[];
        intParallelStream(): Internal.IntStream;
        removeAll(arg0: Internal.IntCollection_): boolean;
        intIterator(): Internal.IntIterator;
        removeIf(arg0: Internal.IntPredicate_): boolean;
        addAll(arg0: Internal.IntCollection_): boolean;
        retainAll(arg0: Internal.IntCollection_): boolean;
        iterator(): Internal.Iterator<any>;
        forEach(arg0: it.unimi.dsi.fastutil.ints.IntConsumer_): void;
        add(arg0: number): boolean;
        /**
         * @deprecated
        */
        forEach(arg0: Internal.Consumer_<number>): void;
        containsAll(arg0: Internal.IntCollection_): boolean;
        /**
         * @deprecated
        */
        toIntArray(arg0: number[]): number[];
        /**
         * @deprecated
        */
        parallelStream(): Internal.Stream<number>;
        /**
         * @deprecated
        */
        removeIf(arg0: Internal.Predicate_<number>): boolean;
        removeIf(arg0: it.unimi.dsi.fastutil.ints.IntPredicate_): boolean;
        intSpliterator(): Internal.IntSpliterator;
        spliterator(): Internal.Spliterator<any>;
        rem(arg0: number): boolean;
    }
    type AbstractIntCollection_ = AbstractIntCollection;
    class CeilingHangingSignBlockBOP extends Internal.CeilingHangingSignBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_, type: Internal.WoodType_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type CeilingHangingSignBlockBOP_ = CeilingHangingSignBlockBOP;
    interface LootPoolEntry {
        abstract getWeight(arg0: number): number;
        abstract createItemStack(arg0: Internal.Consumer_<Internal.ItemStack>, arg1: Internal.LootContext_): void;
    }
    type LootPoolEntry_ = LootPoolEntry;
    class ElevatorPulleyBlockEntity extends Internal.PulleyBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        addExceptionToTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>): boolean;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        clicked(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getRenderBoundingBox(): Internal.AABB;
        get infiniteBoundingBox(): Internal.AABB
        get renderBoundingBox(): Internal.AABB
    }
    type ElevatorPulleyBlockEntity_ = ElevatorPulleyBlockEntity;
    /**
     * Invoked when an entity eats food.
    */
    class FoodEatenEventJS extends Internal.EntityEventJS {
        constructor(e: Internal.LivingEntity_, is: Internal.ItemStack_)
        /**
         * The food that was eaten.
        */
        getItem(): Internal.ItemStack;
        /**
         * The food that was eaten.
        */
        get item(): Internal.ItemStack
    }
    type FoodEatenEventJS_ = FoodEatenEventJS;
    class ClipperItem extends Internal.Item {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ClipperItem_ = ClipperItem;
    class PaintingTextureManager extends Internal.TextureAtlasHolder {
        constructor($$0: Internal.TextureManager_)
        get($$0: Internal.PaintingVariant_): Internal.TextureAtlasSprite;
        getName(): string;
        getBackSprite(): Internal.TextureAtlasSprite;
        get name(): string
        get backSprite(): Internal.TextureAtlasSprite
    }
    type PaintingTextureManager_ = PaintingTextureManager;
    interface IPatternDetails {
        pushInputsToExternalInventory(inputHolder: Internal.KeyCounter_[], inputSink: Internal.IPatternDetails$PatternInputSink_): void;
        abstract getDefinition(): Internal.AEItemKey;
        getPrimaryOutput(): Internal.GenericStack;
        abstract getInputs(): any[];
        supportsPushInputsToExternalInventory(): boolean;
        abstract getOutputs(): Internal.GenericStack[];
        get definition(): Internal.AEItemKey
        get primaryOutput(): Internal.GenericStack
        get inputs(): any[]
        get outputs(): Internal.GenericStack[]
    }
    type IPatternDetails_ = IPatternDetails;
    class RailBlock extends Internal.BaseRailBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly SHAPE: Internal.EnumProperty<Internal.RailShape>;
    }
    type RailBlock_ = RailBlock;
    interface PoseStackExtension {
        abstract flywheel$transformStack(): Internal.PoseTransformStack;
        (): Internal.PoseTransformStack_;
    }
    type PoseStackExtension_ = PoseStackExtension;
    class LevelExtensions$ChangedPosData extends Internal.Record {
        constructor(pos: BlockPos_, state: Internal.BlockState_, flags: number)
        flags(): number;
        pos(): BlockPos;
        state(): Internal.BlockState;
    }
    type LevelExtensions$ChangedPosData_ = LevelExtensions$ChangedPosData;
    class RedMapleLeafPileFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(deserializer: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type RedMapleLeafPileFeature_ = RedMapleLeafPileFeature;
    class FluidParticleData$Type extends Internal.ParticleType<Internal.FluidParticleData> {
        constructor()
        codec(): Internal.Codec<Internal.FluidParticleData>;
    }
    type FluidParticleData$Type_ = FluidParticleData$Type;
    class Animation$Direction extends Internal.Enum<Internal.Animation$Direction> {
        static values(): Internal.Animation$Direction[];
        reversed(): this;
        static valueOf(name: string): Internal.Animation$Direction;
        readonly multiplier: number;
        static readonly FORWARDS: Internal.Animation$Direction;
        static readonly BACKWARDS: Internal.Animation$Direction;
        readonly targetDelta: number;
    }
    type Animation$Direction_ = "backwards" | Animation$Direction | "forwards";
    class LayerLightSectionStorage$SectionType extends Internal.Enum<Internal.LayerLightSectionStorage$SectionType> {
        static values(): Internal.LayerLightSectionStorage$SectionType[];
        display(): string;
        static valueOf($$0: string): Internal.LayerLightSectionStorage$SectionType;
        static readonly LIGHT_AND_DATA: Internal.LayerLightSectionStorage$SectionType;
        static readonly LIGHT_ONLY: Internal.LayerLightSectionStorage$SectionType;
        static readonly EMPTY: Internal.LayerLightSectionStorage$SectionType;
    }
    type LayerLightSectionStorage$SectionType_ = LayerLightSectionStorage$SectionType | "light_and_data" | "empty" | "light_only";
    class ItemAlchemySword extends Internal.SwordItem {
        constructor(toolmaterial: Internal.Tier_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemAlchemySword_ = ItemAlchemySword;
    class StrippableLogBlock extends Internal.RotatedPillarBlock {
        constructor(stripped: Internal.Supplier_<Internal.Block>, properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type StrippableLogBlock_ = StrippableLogBlock;
    interface Cullable {
        abstract setCulled(arg0: boolean): void;
        abstract setOutOfCamera(arg0: boolean): void;
        abstract setTimeout(): void;
        abstract isForcedVisible(): boolean;
        abstract isCulled(): boolean;
        abstract isOutOfCamera(): boolean;
        set culled(arg0: boolean)
        set outOfCamera(arg0: boolean)
        get forcedVisible(): boolean
        get culled(): boolean
        get outOfCamera(): boolean
    }
    type Cullable_ = Cullable;
    abstract class MenuComponent implements Internal.Serializable {
        constructor()
        getParent(): Internal.MenuContainer;
        removeNotify(): void;
        setName(arg0: string): void;
        getName(): string;
        setFont(arg0: Internal.Font_): void;
        /**
         * @deprecated
        */
        postEvent(arg0: Internal.Event_): boolean;
        getAccessibleContext(): Internal.AccessibleContext;
        dispatchEvent(arg0: Internal.AWTEvent_): void;
        getFont(): Internal.Font;
        get parent(): Internal.MenuContainer
        set name(arg0: string)
        get name(): string
        set font(arg0: Internal.Font_)
        get accessibleContext(): Internal.AccessibleContext
        get font(): Internal.Font
    }
    type MenuComponent_ = MenuComponent;
    interface CustomEnchantingBehaviorItem {
        isBookEnchantable(stack: Internal.ItemStack_, book: Internal.ItemStack_): boolean;
        canApplyAtEnchantingTable(stack: Internal.ItemStack_, enchantment: Internal.Enchantment_): boolean;
    }
    type CustomEnchantingBehaviorItem_ = CustomEnchantingBehaviorItem;
    interface Cache <K, V> {
        abstract get(arg0: K, arg1: Internal.Callable_<V>): V;
        abstract asMap(): Internal.ConcurrentMap<K, V>;
        abstract invalidateAll(arg0: Internal.Iterable_<any>): void;
        abstract getAllPresent(arg0: Internal.Iterable_<any>): Internal.ImmutableMap<K, V>;
        abstract invalidateAll(): void;
        abstract getIfPresent(arg0: any): V;
        abstract stats(): Internal.CacheStats;
        abstract cleanUp(): void;
        abstract size(): number;
        abstract invalidate(arg0: any): void;
        abstract putAll(arg0: Internal.Map_<K, V>): void;
        abstract put(arg0: K, arg1: V): void;
    }
    type Cache_<K, V> = Cache<K, V>;
    class HauntedBellBlock extends Internal.AbstractBellBlock<Internal.HauntedBellBlockEntity> {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.HauntedBellBlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.HauntedBellBlockEntity>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        getBlockEntityClass(): typeof Internal.HauntedBellBlockEntity;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.HauntedBellBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        setDestroySpeed(v: number): void;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.HauntedBellBlockEntity>): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getBlockEntityType(): Internal.BlockEntityType<Internal.HauntedBellBlockEntity>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        get blockEntityClass(): typeof Internal.HauntedBellBlockEntity
        set destroySpeed(v: number)
        get blockEntityType(): Internal.BlockEntityType<Internal.HauntedBellBlockEntity>
    }
    type HauntedBellBlock_ = HauntedBellBlock;
    class OreVeinAtlasClickPacket2$Option extends Internal.Enum<Internal.OreVeinAtlasClickPacket2$Option> {
        static valueOf(name: string): Internal.OreVeinAtlasClickPacket2$Option;
        static values(): Internal.OreVeinAtlasClickPacket2$Option[];
        static readonly TOGGLE_HIDE: Internal.OreVeinAtlasClickPacket2$Option;
    }
    type OreVeinAtlasClickPacket2$Option_ = "toggle_hide" | OreVeinAtlasClickPacket2$Option;
    interface MapLike <T> {
        abstract get(arg0: string): T;
        forMap<T>(arg0: Internal.Map_<T, T>, arg1: Internal.DynamicOps_<T>): this;
        abstract get(arg0: T): T;
        abstract entries(): Internal.Stream<com.mojang.datafixers.util.Pair<T, T>>;
    }
    type MapLike_<T> = MapLike<T>;
    interface RecipeComponentWithParent <T> extends Internal.RecipeComponent<T> {
        and<O>(other: Internal.RecipeComponent_<O>): Internal.AndRecipeComponent<T, O>;
        /**
         * Returns a new RecipeComponent that applies the mappingTo function to the input before it is passed to this component to be read
        */
        mapIn(mappingTo: Internal.UnaryOperator_<any>): Internal.MappingRecipeComponent<T>;
        abstract parentComponent(): Internal.RecipeComponent<T>;
        isOutput(recipe: Internal.RecipeJS_, value: T, match: Internal.ReplacementMatch_): boolean;
        key(name: string): Internal.RecipeKey<T>;
        read(recipe: Internal.RecipeJS_, from: any): T;
        orSelf(): Internal.RecipeComponent<T>;
        checkEmpty(key: Internal.RecipeKey_<T>, value: T): string;
        role(): Internal.ComponentRole;
        componentClass(): typeof any;
        /**
         * Returns a new RecipeComponent that applies the mappingTo function to the input before it is passed to this component to be read, and the mappingFrom function after the component writes to json, before that json is saved
        */
        map(mappingTo: Internal.UnaryOperator_<any>, mappingFrom: Internal.UnaryOperator_<Internal.JsonElement>): Internal.MappingRecipeComponent<T>;
        replaceInput(recipe: Internal.RecipeJS_, original: T, match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): T;
        checkValueHasChanged(oldValue: T, newValue: T): boolean;
        readFromJson(recipe: Internal.RecipeJS_, cv: Internal.RecipeComponentValue_<T>, json: Internal.JsonObject_): void;
        constructorDescription(ctx: Internal.DescriptionContext_): Internal.TypeDescJS;
        componentType(): string;
        builder(): Internal.RecipeComponentBuilder;
        hasPriority(recipe: Internal.RecipeJS_, from: any): boolean;
        replaceOutput(recipe: Internal.RecipeJS_, original: T, match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): T;
        /**
         * Returns a new RecipeComponent that maps the keys in a JsonObject according to the provided map, both before the json gets passed to the component and after the component returns a written json object.
         * The mappings should be provided in the format `{recipe: "component"}` where recipe is the key as in the recipe, and component is the key as how the RecipeComponent expects it.
         * Any keys not included in the provided map will be ignored, and any keys in the provided map that are not in either the input object or output object will be ignored.
         * Note that if the input or output is not a JsonObject (ie its an ItemStack, or it is a JsonPrimitive) then that will pass through this without being modified.
         * If you wish to handle those situations use the actual map function
        */
        simpleMap(mappings: any): Internal.SimpleMappingRecipeComponent<T>;
        asArrayOrSelf(): Internal.ArrayRecipeComponent<T>;
        isInput(recipe: Internal.RecipeJS_, value: T, match: Internal.ReplacementMatch_): boolean;
        builder(...key: Internal.RecipeKey_<any>[]): Internal.RecipeComponentBuilder;
        /**
         * Returns a new RecipeComponent that applies the mappingFrom function after the component writes to json, before that json is saved
        */
        mapOut(mappingFrom: Internal.UnaryOperator_<Internal.JsonElement>): Internal.MappingRecipeComponent<T>;
        asMap<K>(key: Internal.RecipeComponent_<K>): Internal.RecipeComponent<Internal.TinyMap<K, T>>;
        asArray(): Internal.ArrayRecipeComponent<T>;
        asPatternKey(): Internal.RecipeComponent<Internal.TinyMap<string, T>>;
        write(recipe: Internal.RecipeJS_, value: T): Internal.JsonElement;
        writeToJson(recipe: Internal.RecipeJS_, cv: Internal.RecipeComponentValue_<T>, json: Internal.JsonObject_): void;
        readFromMap(recipe: Internal.RecipeJS_, cv: Internal.RecipeComponentValue_<T>, map: Internal.Map_<any, any>): void;
        or<O>(other: Internal.RecipeComponent_<O>): Internal.OrRecipeComponent<T, O>;
        (): Internal.RecipeComponent_<T>;
    }
    type RecipeComponentWithParent_<T> = RecipeComponentWithParent<T>;
    class ShearsItemBuilder extends Internal.ItemBuilder {
        constructor(i: ResourceLocation_)
        createObject(): Internal.Item;
        static isCustomShears(stack: Internal.ItemStack_): boolean;
        speedBaseline(f: number): this;
        static readonly TAG: ResourceLocation;
    }
    type ShearsItemBuilder_ = ShearsItemBuilder;
    interface BogeyVisualizer {
        abstract createVisual(arg0: Internal.VisualizationContext_, arg1: number, arg2: boolean): Internal.BogeyVisual;
        (arg0: Internal.VisualizationContext, arg1: number, arg2: boolean): Internal.BogeyVisual_;
    }
    type BogeyVisualizer_ = BogeyVisualizer;
    class SlimeLeavesBlock extends Internal.LeavesBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_, foliageType: Internal.SlimeType_)
        isShearable(item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_): boolean;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getFoliageType(): Internal.SlimeType;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        onSheared(player: Internal.Player_, item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_, fortune: number): Internal.List<Internal.ItemStack>;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get foliageType(): Internal.SlimeType
    }
    type SlimeLeavesBlock_ = SlimeLeavesBlock;
    class ForgeConfigSpec extends Internal.UnmodifiableConfigWrapper<Internal.UnmodifiableConfig> implements Internal.IConfigSpec<Internal.ForgeConfigSpec> {
        getEnum<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_): T;
        getOrElse<T>(arg0: string, arg1: T): T;
        getLong(arg0: string): number;
        getEnum<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T): T;
        getInt(arg0: Internal.List_<string>): number;
        getByteOrElse(arg0: string, arg1: number): number;
        getShortOrElse(arg0: string, arg1: number): number;
        getLevelComment(path: Internal.List_<string>): string;
        get<T>(arg0: Internal.List_<string>): T;
        getCharOrElse(arg0: string, arg1: string): string;
        contains(arg0: string): boolean;
        getShort(arg0: Internal.List_<string>): number;
        getShortOrElse(arg0: Internal.List_<string>, arg1: number): number;
        isCorrecting(): boolean;
        isNull(arg0: Internal.List_<string>): boolean;
        getIntOrElse(arg0: Internal.List_<string>, arg1: number): number;
        getOrElse<T>(arg0: Internal.List_<string>, arg1: Internal.Supplier_<T>): T;
        getOptionalLong(arg0: string): Internal.OptionalLong;
        getOptional<T>(arg0: Internal.List_<string>): Internal.Optional<T>;
        getOptionalEnum<T extends Internal.Enum<T>>(arg0: string, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_): Internal.Optional<T>;
        getEnum<T extends Internal.Enum<T>>(arg0: string, arg1: T): T;
        getOptional<T>(arg0: string): Internal.Optional<T>;
        getShort(arg0: string): number;
        getOrElse<T>(arg0: string, arg1: Internal.Supplier_<T>): T;
        setConfig(config: Internal.CommentedConfig_): void;
        correct(config: Internal.CommentedConfig_, listener: Internal.ConfigSpec$CorrectionListener_, commentListener: Internal.ConfigSpec$CorrectionListener_): number;
        getChar(arg0: string): string;
        getOrElse<T>(arg0: Internal.List_<string>, arg1: T): T;
        getOptionalLong(arg0: Internal.List_<string>): Internal.OptionalLong;
        getChar(arg0: Internal.List_<string>): string;
        afterReload(): void;
        getValues(): Internal.UnmodifiableConfig;
        get<T>(arg0: string): T;
        getLong(arg0: Internal.List_<string>): number;
        getOptionalEnum<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_): Internal.Optional<T>;
        apply<T>(arg0: Internal.List_<string>): T;
        getLongOrElse(arg0: Internal.List_<string>, arg1: Internal.LongSupplier_): number;
        getInt(arg0: string): number;
        isLoaded(): boolean;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_, arg3: Internal.Supplier_<T>): T;
        getLongOrElse(arg0: Internal.List_<string>, arg1: number): number;
        isCorrect(config: Internal.CommentedConfig_): boolean;
        getIntOrElse(arg0: Internal.List_<string>, arg1: Internal.IntSupplier_): number;
        getLevelTranslationKey(path: Internal.List_<string>): string;
        correct(config: Internal.CommentedConfig_, listener: Internal.ConfigSpec$CorrectionListener_): number;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_): T;
        getRaw<T>(arg0: string): T;
        getIntOrElse(arg0: string, arg1: Internal.IntSupplier_): number;
        isNull(arg0: string): boolean;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T): T;
        getOptionalEnum<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T): Internal.Optional<T>;
        getCharOrElse(arg0: Internal.List_<string>, arg1: string): string;
        getByte(arg0: Internal.List_<string>): number;
        getOptionalEnum<T extends Internal.Enum<T>>(arg0: string, arg1: T): Internal.Optional<T>;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: string, arg1: T): T;
        getByteOrElse(arg0: Internal.List_<string>, arg1: number): number;
        getLongOrElse(arg0: string, arg1: number): number;
        getOptionalInt(arg0: string): Internal.OptionalInt;
        self(): this;
        getLongOrElse(arg0: string, arg1: Internal.LongSupplier_): number;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T, arg2: Internal.Supplier_<T>): T;
        getByte(arg0: string): number;
        getIntOrElse(arg0: string, arg1: number): number;
        save(): void;
        correct(config: Internal.CommentedConfig_): number;
        getOptionalInt(arg0: Internal.List_<string>): Internal.OptionalInt;
        acceptConfig(data: Internal.CommentedConfig_): void;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: string, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_): T;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: string, arg1: T, arg2: Internal.Supplier_<T>): T;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: string, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_, arg3: Internal.Supplier_<T>): T;
        getSpec(): Internal.UnmodifiableConfig;
        apply<T>(arg0: string): T;
        getEnum<T extends Internal.Enum<T>>(arg0: string, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_): T;
        get correcting(): boolean
        set config(config: Internal.CommentedConfig_)
        get values(): Internal.UnmodifiableConfig
        get loaded(): boolean
        get spec(): Internal.UnmodifiableConfig
    }
    type ForgeConfigSpec_ = ForgeConfigSpec;
    interface IntBinaryOperator {
        abstract applyAsInt(arg0: number, arg1: number): number;
        (arg0: number, arg1: number): number;
    }
    type IntBinaryOperator_ = IntBinaryOperator;
    class Sizing$Method extends Internal.Enum<Internal.Sizing$Method> {
        static valueOf(name: string): Internal.Sizing$Method;
        static values(): Internal.Sizing$Method[];
        static readonly FIXED: Internal.Sizing$Method;
        static readonly FILL: Internal.Sizing$Method;
        static readonly CONTENT: Internal.Sizing$Method;
    }
    type Sizing$Method_ = "fixed" | Sizing$Method | "content" | "fill";
    interface MenuConstructor {
        abstract createMenu(arg0: number, arg1: Internal.Inventory_, arg2: Internal.Player_): Internal.AbstractContainerMenu;
        (arg0: number, arg1: Internal.Inventory, arg2: Internal.Player): Internal.AbstractContainerMenu_;
    }
    type MenuConstructor_ = MenuConstructor;
    interface RegistrateTagsProvider <T> extends Internal.RegistrateProvider {
        abstract addTag(arg0: Internal.TagKey_<T>): Internal.FabricTagProvider$FabricTagBuilder<>;
        abstract run(arg0: Internal.CachedOutput_): Internal.CompletableFuture<any>;
        abstract getName(): string;
        abstract getSide(): Internal.EnvType;
        saveStable($$0: Internal.CachedOutput_, $$1: Internal.JsonElement_, $$2: Internal.Path_): Internal.CompletableFuture<any>;
        get name(): string
        get side(): Internal.EnvType
    }
    type RegistrateTagsProvider_<T> = RegistrateTagsProvider<T>;
    class DataOutputStream extends Internal.FilterOutputStream implements Internal.DataOutput {
        constructor(arg0: Internal.OutputStream_)
        writeInt(arg0: number): void;
        writeBytes(arg0: string): void;
        writeBoolean(arg0: boolean): void;
        size(): number;
        writeUTF(arg0: string): void;
        writeLong(arg0: number): void;
        writeChars(arg0: string): void;
        writeByte(arg0: number): void;
        writeChar(arg0: number): void;
        writeDouble(arg0: number): void;
        writeFloat(arg0: number): void;
        writeShort(arg0: number): void;
    }
    type DataOutputStream_ = DataOutputStream;
    class MilkFluid$Flowing extends Internal.MilkFluid {
        constructor()
        arch$holder(): Internal.Holder<Internal.Fluid>;
        getFluidDripWorldEvent(state: Internal.BlockState_, world: Internal.Level_, cauldronPos: BlockPos_): number;
        arch$registryName(): ResourceLocation;
    }
    type MilkFluid$Flowing_ = MilkFluid$Flowing;
    class GantryShaftBlockEntity extends Internal.KineticBlockEntity {
        constructor(typeIn: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        checkAttachedCarriageBlocks(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getPinionMovementSpeed(): number;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        canAssembleOn(): boolean;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getRenderBoundingBox(): Internal.AABB;
        get pinionMovementSpeed(): number
        get infiniteBoundingBox(): Internal.AABB
        get renderBoundingBox(): Internal.AABB
    }
    type GantryShaftBlockEntity_ = GantryShaftBlockEntity;
    class SequencedGearshiftBlock extends Internal.HorizontalAxisKineticBlock implements Internal.WeakPowerCheckingBlock, Internal.IBE<Internal.SequencedGearshiftBlockEntity>, Internal.TransformableBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        getBlockEntityType(): Internal.BlockEntityType<Internal.SequencedGearshiftBlockEntity>;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        getBlockEntityClass(): typeof Internal.SequencedGearshiftBlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.SequencedGearshiftBlockEntity;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        hideStressImpact(): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.SequencedGearshiftBlockEntity>): void;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        transform(state: Internal.BlockState_, transform: Internal.StructureTransform_): Internal.BlockState;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        showCapacityWithAnnotation(): boolean;
        shouldCheckWeakPower(state: Internal.BlockState_, level: Internal.SignalGetter_, pos: BlockPos_, side: Internal.Direction_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.SequencedGearshiftBlockEntity>;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.SequencedGearshiftBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        get blockEntityType(): Internal.BlockEntityType<Internal.SequencedGearshiftBlockEntity>
        get blockEntityClass(): typeof Internal.SequencedGearshiftBlockEntity
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
        static readonly VERTICAL: Internal.BooleanProperty;
        static readonly STATE: Internal.IntegerProperty;
    }
    type SequencedGearshiftBlock_ = SequencedGearshiftBlock;
    class MemberType extends Internal.Enum<Internal.MemberType> {
        static values(): Internal.MemberType[];
        static get(value: any, cx: Internal.Context_): Internal.MemberType;
        static valueOf(name: string): Internal.MemberType;
        static readonly OBJECT: Internal.MemberType;
        static readonly BOOLEAN: Internal.MemberType;
        static readonly FUNCTION: Internal.MemberType;
        static readonly STRING: Internal.MemberType;
        static readonly SYMBOL: Internal.MemberType;
        static readonly NUMBER: Internal.MemberType;
        static readonly UNDEFINED: Internal.MemberType;
    }
    type MemberType_ = "string" | "boolean" | MemberType | "symbol" | "function" | "undefined" | "object" | "number";
    abstract class AbstractBannerBlock extends Internal.BaseEntityBlock {
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        getColor(): Internal.DyeColor;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        get color(): Internal.DyeColor
        set destroySpeed(v: number)
    }
    type AbstractBannerBlock_ = AbstractBannerBlock;
    interface Ownable {
        abstract chatheads$getOwner(): Internal.PlayerInfo;
        abstract chatheads$setOwner(arg0: Internal.PlayerInfo_): void;
    }
    type Ownable_ = Ownable;
    class PackOutput$PathProvider {
        json($$0: ResourceLocation_): Internal.Path;
        file($$0: ResourceLocation_, $$1: string): Internal.Path;
        readonly kind: string;
        readonly root: Internal.Path;
    }
    type PackOutput$PathProvider_ = PackOutput$PathProvider;
    class BlockBlobFeature extends Internal.Feature<Internal.BlockStateConfiguration> {
        constructor($$0: Internal.Codec_<Internal.BlockStateConfiguration>)
    }
    type BlockBlobFeature_ = BlockBlobFeature;
    interface IIndexedSchedule {
        abstract railways$setIndex(arg0: number): void;
        abstract railways$getIndex(): number;
    }
    type IIndexedSchedule_ = IIndexedSchedule;
    class PatternProviderReturnInventory extends Internal.GenericStackInv {
        constructor(listener: Internal.Runnable_)
        injectIntoNetwork(storage: Internal.MEStorage_, src: Internal.IActionSource_, insertionCallback: Internal.Consumer_<Internal.GenericStack>): boolean;
        static checkPreconditions(what: Internal.AEKey_, amount: number, mode: Internal.Actionable_, source: Internal.IActionSource_): void;
        isPreferredStorageFor(what: Internal.AEKey_, source: Internal.IActionSource_): boolean;
        addDrops(drops: Internal.List_<Internal.ItemStack>, level: Internal.Level_, pos: BlockPos_): void;
        getAvailableStacks(): Internal.KeyCounter;
        get availableStacks(): Internal.KeyCounter
        static NUMBER_OF_SLOTS: 9;
    }
    type PatternProviderReturnInventory_ = PatternProviderReturnInventory;
    interface IStorageFluidHandler extends Internal.Storage<Internal.FluidVariant> {
        simulateExtract(fluidTag: Internal.TagKey_<Internal.Fluid>, maxFill: number, transaction: Internal.TransactionContext_): Internal.FluidStack;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateExtract(resource: Internal.FluidVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        supportsInsertion(): boolean;
        simulateInsert(fluidTag: Internal.TagKey_<Internal.Fluid>, maxFill: number, fallbackFluid: Internal.Fluid_, transaction: Internal.TransactionContext_): number;
        abstract iterator(): Internal.Iterator<Internal.StorageView<Internal.FluidVariant>>;
        supportsExtraction(): boolean;
        abstract extract(arg0: Internal.TagKey_<Internal.Fluid>, arg1: number, arg2: Internal.TransactionContext_, arg3: boolean): Internal.FluidStack;
        abstract insert(arg0: Internal.FluidVariant_, arg1: number, arg2: Internal.TransactionContext_, arg3: boolean): number;
        forEach(arg0: Internal.Consumer_<Internal.StorageView<T>>): void;
        insert(fluidTag: Internal.TagKey_<Internal.Fluid>, maxFill: number, fallbackFluid: Internal.Fluid_, ctx: Internal.TransactionContext_): number;
        spliterator(): Internal.Spliterator<Internal.StorageView<T>>;
        insert(fluidTag: Internal.TagKey_<Internal.Fluid>, maxFill: number, fallbackFluid: Internal.Fluid_, ctx: Internal.TransactionContext_, ignoreInOutLimit: boolean): number;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateInsert(resource: Internal.FluidVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        abstract extract(arg0: number, arg1: Internal.TransactionContext_, arg2: boolean): Internal.FluidStack;
        abstract extract(arg0: Internal.FluidStack_, arg1: Internal.TransactionContext_, arg2: boolean): Internal.FluidStack;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        exactView(resource: Internal.FluidVariant_): Internal.StorageView<Internal.FluidVariant>;
        asClass<T>(): Internal.Storage<T>;
        extract(fluidTag: Internal.TagKey_<Internal.Fluid>, maxDrain: number, ctx: Internal.TransactionContext_): Internal.FluidStack;
        abstract insert(arg0: Internal.FluidVariant_, arg1: number, arg2: Internal.TransactionContext_): number;
        nonEmptyViews(): Internal.Iterable<Internal.StorageView<Internal.FluidVariant>>;
        abstract extract(arg0: Internal.FluidVariant_, arg1: number, arg2: Internal.TransactionContext_): number;
        abstract extract(arg0: Internal.FluidVariant_, arg1: number, arg2: Internal.TransactionContext_, arg3: boolean): number;
        empty<T>(): Internal.Storage<T>;
        getVersion(): number;
        nonEmptyIterator(): Internal.Iterator<Internal.StorageView<Internal.FluidVariant>>;
        get version(): number
    }
    type IStorageFluidHandler_ = IStorageFluidHandler;
    class EntityClassGroup {
        constructor(classFitEvaluator: Internal.Predicate_<typeof any>)
        clear(): void;
        contains(entityClass: typeof any): boolean;
        static readonly MINECART_BOAT_LIKE_COLLISION: Internal.EntityClassGroup;
    }
    type EntityClassGroup_ = EntityClassGroup;
    class ClientRecipeBook extends Internal.RecipeBook {
        constructor()
        getCollections(): Internal.List<Internal.RecipeCollection>;
        getCollection($$0: Internal.RecipeBookCategories_): Internal.List<Internal.RecipeCollection>;
        setupCollections($$0: Internal.Iterable_<Internal.Recipe<any>>, $$1: Internal.RegistryAccess_): void;
        get collections(): Internal.List<Internal.RecipeCollection>
    }
    type ClientRecipeBook_ = ClientRecipeBook;
    class NetherForestVegetationConfig extends Internal.BlockPileConfiguration {
        constructor($$0: Internal.BlockStateProvider_, $$1: number, $$2: number)
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        static readonly CODEC: Internal.Codec<Internal.NetherForestVegetationConfig>;
        readonly spreadWidth: number;
        readonly spreadHeight: number;
    }
    type NetherForestVegetationConfig_ = NetherForestVegetationConfig;
    class GrandSpellHandler$Factory implements Internal.SpecialHandler$Factory<Internal.GrandSpellHandler> {
        constructor()
        tryMatch(pattern: Internal.HexPattern_, env: Internal.CastingEnvironment_): Internal.GrandSpellHandler;
    }
    type GrandSpellHandler$Factory_ = GrandSpellHandler$Factory;
    class StationBlockEntity extends Internal.SmartBlockEntity implements Internal.TransformableBlockEntity, Internal.SidedStorageBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        dropSchedule(sender: Internal.ServerPlayer_, train: Internal.Train_): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        enterAssemblyMode(sender: Internal.ServerPlayer_): boolean;
        getFluidStorage(side: Internal.Direction_): Internal.Storage<Internal.FluidVariant>;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        isAssembling(): boolean;
        onLoad(): void;
        isValidBogeyOffset(i: number): boolean;
        getItemStorage(face: Internal.Direction_): Internal.Storage<Internal.ItemVariant>;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        exitAssemblyMode(): boolean;
        updateName(name: string): boolean;
        assemble(playerUUID: Internal.UUID_): void;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        attachPackagePort(ppbe: Internal.PackagePortBlockEntity_): void;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        resolveFlagAngle(): boolean;
        invalidateCaps(): void;
        refreshAssemblyInfo(): void;
        tryDisassembleTrain(sender: Internal.ServerPlayer_): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        trackClicked(player: Internal.Player_, hand: Internal.InteractionHand_, track: Internal.ITrackBlock_, state: Internal.BlockState_, pos: BlockPos_): boolean;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        cancelAssembly(): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        transform(be: Internal.BlockEntity_, transform: Internal.StructureTransform_): void;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        removePackagePort(ppbe: Internal.PackagePortBlockEntity_): void;
        tryEnterAssemblyMode(): boolean;
        getStation(): Internal.GlobalStation;
        updateMapColor(color: number): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getAutoSchedule(): Internal.ItemStack;
        getAssemblyDirection(): Internal.Direction;
        get assembling(): boolean
        get infiniteBoundingBox(): Internal.AABB
        get station(): Internal.GlobalStation
        get autoSchedule(): Internal.ItemStack
        get assemblyDirection(): Internal.Direction
        edgePoint: Internal.TrackTargetingBehaviour<Internal.GlobalStation>;
        static assemblyAreas: Internal.WorldAttached<Internal.Map<BlockPos, Internal.BoundingBox>>;
        lastDisassembledTrainName: net.minecraft.network.chat.Component;
        lastDisassembledMapColorIndex: number;
        computerBehaviour: Internal.AbstractComputerBehaviour;
        flag: Internal.LerpedFloat;
        doorControls: Internal.DoorControlBehaviour;
    }
    type StationBlockEntity_ = StationBlockEntity;
    interface ClipboardOwner {
        abstract lostOwnership(arg0: Internal.Clipboard_, arg1: Internal.Transferable_): void;
        (arg0: Internal.Clipboard, arg1: Internal.Transferable): void;
    }
    type ClipboardOwner_ = ClipboardOwner;
    interface BlockMatchTestAccessor {
        abstract getBlock(): Internal.Block;
        get block(): Internal.Block
        (): Internal.Block_;
    }
    type BlockMatchTestAccessor_ = BlockMatchTestAccessor;
    abstract class GaugeBlockEntity extends Internal.KineticBlockEntity implements Internal.IHaveGoggleInformation {
        constructor(typeIn: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        write(compound: Internal.CompoundTag_, clientPacket: boolean): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getRenderBoundingBox(): Internal.AABB;
        get infiniteBoundingBox(): Internal.AABB
        get renderBoundingBox(): Internal.AABB
        dialTarget: number;
        prevDialState: number;
        dialState: number;
        color: number;
    }
    type GaugeBlockEntity_ = GaugeBlockEntity;
    class BlockEntityInfo {
        constructor(blockBuilder: Internal.BlockBuilder_)
        enableSync(): void;
        tick(frequency: number, offset: number, callback: Internal.BlockEntityCallback_): void;
        clientTick(frequency: number, offset: number, callback: Internal.BlockEntityCallback_): void;
        attach(type: "inventory", input: {xsize: number, inputFilter?: Ingredient, ysize: number}): void;
        serverTick(frequency: number, offset: number, callback: Internal.BlockEntityCallback_): void;
        rightClickOpensInventory(): void;
        tick(callback: Internal.BlockEntityCallback_): void;
        initialData(data: Internal.CompoundTag_): void;
        serverTick(callback: Internal.BlockEntityCallback_): void;
        inventory(width: number, height: number, inputFilter: Internal.Ingredient_): void;
        inventory(width: number, height: number): void;
        clientTick(callback: Internal.BlockEntityCallback_): void;
        eventHandler(eventId: number, callback: Internal.BlockEntityEventCallback_): void;
    }
    type BlockEntityInfo_ = BlockEntityInfo;
    interface LevelReaderMixin extends Internal.LevelReaderExtensions {
        isAreaLoaded(center: BlockPos_, range: number): boolean;
    }
    type LevelReaderMixin_ = LevelReaderMixin;
    interface Vector4fc {
        abstract get(arg0: number, arg1: Internal.Vector4i_): Internal.Vector4i;
        abstract normalize3(arg0: Vec4f_): Vec4f;
        abstract get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract hermite(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Internal.Vector4fc_, arg3: number, arg4: Vec4f_): Vec4f;
        abstract get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
        abstract distance(arg0: Internal.Vector4fc_): number;
        abstract mul(arg0: number, arg1: Vec4f_): Vec4f;
        abstract mul(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
        abstract isFinite(): boolean;
        abstract get(arg0: Vec4f_): Vec4f;
        abstract dot(arg0: number, arg1: number, arg2: number, arg3: number): number;
        abstract rotateX(arg0: number, arg1: Vec4f_): Vec4f;
        abstract fma(arg0: number, arg1: Internal.Vector4fc_, arg2: Vec4f_): Vec4f;
        abstract rotateZ(arg0: number, arg1: Vec4f_): Vec4f;
        abstract mulAdd(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Vec4f_): Vec4f;
        abstract lerp(arg0: Internal.Vector4fc_, arg1: number, arg2: Vec4f_): Vec4f;
        abstract z(): number;
        abstract min(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
        abstract x(): number;
        abstract absolute(arg0: Vec4f_): Vec4f;
        abstract div(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
        abstract dot(arg0: Internal.Vector4fc_): number;
        abstract div(arg0: number, arg1: Vec4f_): Vec4f;
        abstract mulTranspose(arg0: Internal.Matrix4fc_, arg1: Vec4f_): Vec4f;
        abstract mulAffine(arg0: Internal.Matrix4fc_, arg1: Vec4f_): Vec4f;
        abstract round(arg0: Vec4f_): Vec4f;
        abstract lengthSquared(): number;
        abstract get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
        abstract fma(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Vec4f_): Vec4f;
        abstract get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract get(arg0: number): number;
        abstract distanceSquared(arg0: Internal.Vector4fc_): number;
        abstract mulAdd(arg0: number, arg1: Internal.Vector4fc_, arg2: Vec4f_): Vec4f;
        abstract mulProject(arg0: Internal.Matrix4fc_, arg1: Vec4f_): Vec4f;
        abstract add(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
        abstract minComponent(): number;
        abstract sub(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
        abstract maxComponent(): number;
        abstract equals(arg0: Internal.Vector4fc_, arg1: number): boolean;
        abstract negate(arg0: Vec4f_): Vec4f;
        abstract sub(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
        abstract get(arg0: Internal.Vector4d_): Internal.Vector4d;
        abstract getToAddress(arg0: number): this;
        abstract max(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
        abstract equals(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
        abstract rotateY(arg0: number, arg1: Vec4f_): Vec4f;
        abstract add(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
        abstract mulProject(arg0: Internal.Matrix4fc_, arg1: Vec3f_): Vec3f;
        abstract ceil(arg0: Vec4f_): Vec4f;
        abstract rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
        abstract y(): number;
        abstract rotate(arg0: Internal.Quaternionfc_, arg1: Vec4f_): Vec4f;
        abstract mulAffineTranspose(arg0: Internal.Matrix4fc_, arg1: Vec4f_): Vec4f;
        abstract w(): number;
        abstract length(): number;
        abstract mul(arg0: Internal.Matrix4fc_, arg1: Vec4f_): Vec4f;
        abstract distanceSquared(arg0: number, arg1: number, arg2: number, arg3: number): number;
        abstract normalize(arg0: Vec4f_): Vec4f;
        abstract smoothStep(arg0: Internal.Vector4fc_, arg1: number, arg2: Vec4f_): Vec4f;
        abstract mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
        abstract floor(arg0: Vec4f_): Vec4f;
        abstract mul(arg0: Internal.Matrix4x3fc_, arg1: Vec4f_): Vec4f;
        abstract distance(arg0: number, arg1: number, arg2: number, arg3: number): number;
        abstract div(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
        abstract angle(arg0: Internal.Vector4fc_): number;
        abstract angleCos(arg0: Internal.Vector4fc_): number;
        abstract normalize(arg0: number, arg1: Vec4f_): Vec4f;
        get finite(): boolean
    }
    type Vector4fc_ = Vector4fc;
    class ArmorMaterials extends Internal.Enum<Internal.ArmorMaterials> implements Internal.ArmorMaterial, Internal.StringRepresentable {
        getDefenseForType($$0: Internal.ArmorItem$Type_): number;
        getDurabilityForType($$0: Internal.ArmorItem$Type_): number;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getRepairIngredient(): Internal.Ingredient;
        getSerializedName(): string;
        getKnockbackResistance(): number;
        getEnchantmentValue(): number;
        static valueOf($$0: string): Internal.ArmorMaterials;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        getName(): string;
        getToughness(): number;
        static values(): Internal.ArmorMaterials[];
        getEquipSound(): Internal.SoundEvent;
        get repairIngredient(): Internal.Ingredient
        get serializedName(): string
        get knockbackResistance(): number
        get enchantmentValue(): number
        get name(): string
        get toughness(): number
        get equipSound(): Internal.SoundEvent
        static readonly LEATHER: Internal.ArmorMaterials;
        static readonly GOLD: Internal.ArmorMaterials;
        static readonly TURTLE: Internal.ArmorMaterials;
        static readonly DIAMOND: Internal.ArmorMaterials;
        static readonly IRON: Internal.ArmorMaterials;
        static readonly CHAIN: Internal.ArmorMaterials;
        static readonly NETHERITE: Internal.ArmorMaterials;
        static readonly CODEC: Internal.StringRepresentable$EnumCodec<Internal.ArmorMaterials>;
    }
    type ArmorMaterials_ = "gold" | "diamond" | ArmorMaterials | "chain" | "iron" | "turtle" | "netherite" | "leather";
    class AlgalEndStoneBlock extends Internal.Block implements Internal.BonemealableBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        isBonemealSuccess(p_153802_: Internal.Level_, p_153803_: Internal.RandomSource_, p_153804_: BlockPos_, p_153805_: Internal.BlockState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        performBonemeal(p_221270_: Internal.ServerLevel_, p_221271_: Internal.RandomSource_, p_221272_: BlockPos_, p_221273_: Internal.BlockState_): void;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        isValidBonemealTarget(p_153797_: Internal.LevelReader_, p_153798_: BlockPos_, p_153799_: Internal.BlockState_, b: boolean): boolean;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type AlgalEndStoneBlock_ = AlgalEndStoneBlock;
    class WeightedRandomList <E extends Internal.WeightedEntry> implements Internal.AccessorWeightedRandomList<any> {
        unwrap(): Internal.List<any>;
        static create<E extends Internal.WeightedEntry>(): Internal.WeightedRandomList<E>;
        static create<E extends Internal.WeightedEntry>(...$$0: E[]): Internal.WeightedRandomList<E>;
        bookshelf$getTotalWeight(): number;
        isEmpty(): boolean;
        static create<E extends Internal.WeightedEntry>($$0: Internal.List_<E>): Internal.WeightedRandomList<E>;
        bookshelf$getEntries(): Internal.ImmutableList<any>;
        getRandom($$0: Internal.RandomSource_): Internal.Optional<E>;
        static codec<E extends Internal.WeightedEntry>($$0: Internal.Codec_<E>): Internal.Codec<Internal.WeightedRandomList<E>>;
        get empty(): boolean
    }
    type WeightedRandomList_<E extends Internal.WeightedEntry> = WeightedRandomList<E>;
    class HopperBlock extends Internal.BaseEntityBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly ENABLED: Internal.BooleanProperty;
        static readonly FACING: Internal.DirectionProperty;
    }
    type HopperBlock_ = HopperBlock;
    class BucketItem extends Internal.Item implements Internal.BucketItemAccessor, net.fabricmc.fabric.mixin.transfer.BucketItemAccessor, Internal.DispensibleContainerItem, Internal.InjectedBucketItemExtension, io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor.BucketItemAccessor {
        constructor($$0: Internal.Fluid_, $$1: Internal.Item$Properties_)
        arch$getFluid(): Internal.Fluid;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        getContent(): Internal.Fluid;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        static getEmptySuccessItem($$0: Internal.ItemStack_, $$1: Internal.Player_): Internal.ItemStack;
        setAttackSpeed(attackSpeed: number): void;
        handler$znc000$architectury$fillBucket(level: Internal.Level_, player: Internal.Player_, hand: Internal.InteractionHand_, cir: Internal.CallbackInfoReturnable_<any>, stack: Internal.ItemStack_, target: Internal.BlockHitResult_): void;
        port_lib$getContent(): Internal.Fluid;
        fabric_getFluid(): Internal.Fluid;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        emptyContents($$0: Internal.Player_, $$1: Internal.Level_, $$2: BlockPos_, $$3: Internal.BlockHitResult_): boolean;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        checkExtraContent($$0: Internal.Player_, $$1: Internal.Level_, $$2: Internal.ItemStack_, $$3: BlockPos_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        get content(): Internal.Fluid
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        readonly content: Internal.Fluid;
    }
    type BucketItem_ = BucketItem;
    interface IntProviderType <P extends Internal.IntProvider> {
        abstract codec(): Internal.Codec<P>;
        register<P extends Internal.IntProvider>($$0: string, $$1: Internal.Codec_<P>): this;
        (): Internal.Codec_<P>;
        readonly BIASED_TO_BOTTOM: Internal.IntProviderType<Internal.BiasedToBottomInt>;
        readonly UNIFORM: Internal.IntProviderType<Internal.UniformInt>;
        readonly CLAMPED: Internal.IntProviderType<Internal.ClampedInt>;
        readonly CLAMPED_NORMAL: Internal.IntProviderType<Internal.ClampedNormalInt>;
        readonly WEIGHTED_LIST: Internal.IntProviderType<Internal.WeightedListInt>;
        readonly CONSTANT: Internal.IntProviderType<Internal.ConstantInt>;
    }
    type IntProviderType_<P extends Internal.IntProvider> = IntProviderType<P> | Special.IntProviderType;
    class FluidContentsAttribute$Type implements Internal.ItemAttributeType {
        constructor()
        getAllAttributes(stack: Internal.ItemStack_, level: Internal.Level_): Internal.List<Internal.ItemAttribute>;
        createAttribute(): Internal.ItemAttribute;
    }
    type FluidContentsAttribute$Type_ = FluidContentsAttribute$Type;
}
declare namespace owmii.powah.item {
    class WrenchItem extends owmii.powah.lib.item.ItemBase implements Internal.IHudItem, Internal.IWrench {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        oneTimeInfo(player: Internal.Player_, stack: Internal.ItemStack_, component: net.minecraft.network.chat.Component_): void;
        renderHud(world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, hand: Internal.InteractionHand_, side: Internal.Direction_, hit: Vec3d_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getWrenchNBT(stack: Internal.ItemStack_): Internal.CompoundTag;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        getItemModelType(): Internal.ItemModelType;
        emi(amount: number): Internal.EmiStack;
        getWrenchMode(stack: Internal.ItemStack_): Internal.WrenchMode;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get itemModelType(): Internal.ItemModelType
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type WrenchItem_ = WrenchItem;
}
declare namespace net.blay09.mods.balm.mixin {
    interface AbstractContainerScreenAccessor {
        abstract callIsHovering(arg0: Internal.Slot_, arg1: number, arg2: number): boolean;
        abstract getImageHeight(): number;
        abstract getHoveredSlot(): Internal.Slot;
        abstract getTopPos(): number;
        abstract callRenderSlot(arg0: Internal.GuiGraphics_, arg1: Internal.Slot_): void;
        abstract getImageWidth(): number;
        abstract getLeftPos(): number;
        get imageHeight(): number
        get hoveredSlot(): Internal.Slot
        get topPos(): number
        get imageWidth(): number
        get leftPos(): number
    }
    type AbstractContainerScreenAccessor_ = AbstractContainerScreenAccessor;
}
declare namespace io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor {
    interface SlotAccessor {
        abstract port_lib$getSlotIndex(): number;
        (): number;
    }
    type SlotAccessor_ = SlotAccessor;
    interface ServerPlayerAccessor {
        abstract callInitMenu(arg0: Internal.AbstractContainerMenu_): void;
        abstract getContainerCounter(): number;
        abstract callNextContainerCounter(): void;
        get containerCounter(): number
    }
    type ServerPlayerAccessor_ = ServerPlayerAccessor;
}
declare namespace com.tterrag.registrate.util.nullness {
    interface NonNullConsumer <T> extends Internal.Consumer<T> {
        andThen(after: com.tterrag.registrate.util.nullness.NonNullConsumer_<T>): this;
        andThen(arg0: Internal.Consumer_<T>): Internal.Consumer<T>;
        noop<T>(): this;
        abstract accept(arg0: T): void;
        (arg0: T): void;
    }
    type NonNullConsumer_<T> = NonNullConsumer<T>;
}
